/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.parser;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import gnu.trove.set.hash.THashSet;
import it.jrc.osint.analysis.ElementParsingResult;
import it.jrc.osint.analysis.parser.ElementParsingResultImpl;
import it.jrc.osint.analysis.parser.ParseException;
import it.jrc.osint.analysis.relation.EntityTextPosition;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.rss.SimpleAttribute;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;

public class EntityElementParser {
    private static final Logger log = LogManager.getLogger((String)EntityElementParser.class.getName());
    private Automaton geoTagMatcher;

    public EntityElementParser() {
        RegExp r = new RegExp("emm:(georss)");
        this.geoTagMatcher = r.toAutomaton();
    }

    public ElementParsingResult parseElement(SimpleElement se, ElementParsingResultImpl epr) throws ParseException {
        if (se == null) {
            epr.setStatus(OperationStatus.CANCEL_STATUS);
            return epr;
        }
        if (!this.isEntityElement(se)) {
            epr.setStatus(OperationStatus.CANCEL_STATUS);
            return epr;
        }
        Entity parsedEntity = this.parseEntity(se);
        epr.setEntity(parsedEntity);
        epr.setEntityTextPositions(this.parseTextPosition(se));
        return epr;
    }

    public boolean isEntityElement(SimpleElement se) {
        String type;
        String elementName = se.getName();
        if (elementName == null || "".equals(elementName)) {
            throw new IllegalArgumentException("Invalid SimpleElement instance");
        }
        if (elementName.equals("emm:entity")) {
            type = se.getAttributeValue("type");
            if (type == null || "".equals(type)) {
                throw new IllegalArgumentException("Invalid entity type");
            }
            if (type.equals("p")) {
                return true;
            }
            if (type.equals("o")) {
                return true;
            }
        }
        if (elementName.equals("emm:custom") && (type = se.getAttributeValue("type")) != null) {
            return true;
        }
        if (elementName.equals("emm:guess")) {
            return true;
        }
        return this.geoTagMatcher.run(elementName);
    }

    private Entity parseEntity(SimpleElement se) {
        String elementName = se.getName();
        String profileId = null;
        SimpleAttribute idAttr = se.getAttribute("id");
        if (idAttr == null || "".equals(idAttr.value)) {
            log.warn("parseEntity: SimpleElement with name: " + elementName + " contains no id for entity" + se.toString());
            profileId = Integer.toString(UUID.randomUUID().hashCode());
        } else {
            profileId = idAttr.value;
        }
        Entity parsedEntity = new Entity(Long.parseLong(profileId));
        if (elementName.equals("emm:georss")) {
            parsedEntity.setField("type", "t");
        }
        ArrayList attributes = se.getAttributes();
        for (SimpleAttribute sa : attributes) {
            if ("id".equals(sa.name)) continue;
            parsedEntity.setField(sa.name, sa.value);
        }
        return parsedEntity;
    }

    private Set<EntityTextPosition> parseTextPosition(SimpleElement se) throws ParseException {
        THashSet tpSet = new THashSet();
        String posStr = se.getAttributeValue("pos");
        if (posStr == null) {
            posStr = se.getAttributeValue("charpos");
        }
        if (posStr == null) {
            log.error("Could not parse pos from SimpleElement " + se.toString());
            return tpSet;
        }
        int[] positions = this.toIntArray(posStr);
        String foundText = se.getValue();
        int posLength = foundText.length();
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int foundPos = nArray[n2];
            tpSet.add(new EntityTextPosition(foundPos, posLength));
            ++n2;
        }
        return tpSet;
    }

    private int[] toIntArray(String str) throws ParseException {
        if (str == null || "".equals(str)) {
            return new int[0];
        }
        try {
            String[] intParts = str.split(",");
            int[] results = null;
            if ("".equals(intParts[intParts.length - 1])) {
                results = new int[intParts.length - 1];
            }
            results = new int[intParts.length];
            int i = 0;
            String[] stringArray = intParts;
            int n = intParts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (!"".equals(part)) {
                    results[i++] = Integer.parseInt(part);
                }
                ++n2;
            }
            return results;
        }
        catch (Throwable t) {
            throw new ParseException("Failed to parse to int array", t);
        }
    }
}

