/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.relation;

import com.google.common.collect.Sets;
import gnu.trove.set.hash.THashSet;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.analysis.relation.EntityTextPosition;
import it.jrc.osint.extract.entities.Entity;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DocumentEntityRelationImpl
implements DocumentEntityRelation {
    public static final DocumentEntityRelation NULL_RELATION = new DocumentEntityRelationImpl(Entity.NULL_ENTITY, "", (Set<EntityTextPosition>)new THashSet());
    private Set<EntityTextPosition> textPositions = new THashSet();
    private Entity entity;
    private String resourceId;
    private final int hashCode;

    public DocumentEntityRelationImpl(Entity anEntity, String aResourceId, Set<EntityTextPosition> textPositions) {
        this.entity = anEntity;
        this.resourceId = aResourceId;
        this.textPositions = textPositions;
        this.hashCode = new HashCodeBuilder(7, 13).append((Object)anEntity.getName()).append((Object)aResourceId.toString()).hashCode();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public String getDocumentId() {
        return this.resourceId;
    }

    @Override
    public void addTextPositions(Set<EntityTextPosition> positionSet) {
        this.textPositions = Sets.union(this.textPositions, positionSet);
    }

    @Override
    public int getWeight() {
        return this.textPositions.size();
    }

    @Override
    public Set<EntityTextPosition> getTextPositions() {
        return this.textPositions;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof DocumentEntityRelationImpl) {
            DocumentEntityRelationImpl otherRelation = (DocumentEntityRelationImpl)other;
            return this.entity.equals((Object)otherRelation.entity) && this.resourceId.equals(otherRelation.resourceId);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this == NULL_RELATION) {
            return "NULL_RELATION";
        }
        return "[eid:" + this.entity.getId() + ", rid:" + this.resourceId + "]";
    }
}

