/*
 * generated by Xtext
 */
package it.jrc.osint.cmatcher.generator

import it.jrc.osint.cmatcher.alertDSL.Alert
import it.jrc.osint.cmatcher.alertDSL.CombinationType
import it.jrc.osint.cmatcher.alertDSL.PatternSection
import it.jrc.osint.cmatcher.alertDSL.PatternWeightType
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.IFileSystemAccess
import org.eclipse.xtext.generator.IGenerator
import it.jrc.osint.cmatcher.alertDSL.OrType
import it.jrc.osint.cmatcher.alertDSL.Model
import org.eclipse.emf.common.util.EList

/**
 * Generates code from your model files on save.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
class AlertDSLGenerator implements IGenerator {
	
	val DEFAULT_THRESHOLD = 25
	val DEFAULT_PROXIMITY = 10;
	
	override void doGenerate(Resource resource, IFileSystemAccess fsa) {
		  var EObject headObject = resource.contents.head;
		  if (headObject instanceof Model) {
		  	val EList<Alert> alerts = (headObject as Model).alerts;
		  	if (alerts.empty) {
		  		println("Alerts list of model is empty: no Alert object found");
		  	} else {
		  		val Alert alert = alerts.head as Alert;
		  		fsa.generateFile(alert.id + ".xml",  alert.compile);	
		  	}
		    	
		  } else {
		  	println("No Alert object found");
		  }
	}
	
	def compile(Alert a) '''
		<?xml version="1.0" encoding="UTF-8" ?>
		<alertInfo xsi:noNamespaceSchemaLocation="http://emm.jrc.org/alert.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
		<alerts>
		<alert id="«a.id»">
		<definition>
		«IF a.patternSection != null»
			«a.patternSection.compile()»
		«ENDIF»
		<mustContain>
		«FOR c : a.combinationSection»
			«c.combination.compile()»
		«ENDFOR»
		</mustContain>
		</definition>
		</alert>
		</alerts>
		</alertInfo>		
	'''
	
	def compile(PatternSection ps) '''
		<words threshold="«IF ps.threshold == 0»«DEFAULT_THRESHOLD»«ELSE»«ps.threshold»«ENDIF»">
			«FOR p : ps.patterns»
				«p.compile()»
			«ENDFOR»	
		</words>
	'''
	
	def compile(PatternWeightType pwt)'''
		<word>
			<pattern>«pwt.pattern»</pattern>
			<weight>«pwt.weight»</weight>
		</word>
	'''
	
	def compile(CombinationType ct) '''
		<combination proximity="«IF ct.proximity==0»«DEFAULT_PROXIMITY»«ELSE»«ct.proximity»«ENDIF»">
		«FOR or: ct.ors»
			«or.compile()»
		«ENDFOR»
		«IF ct.not != null»
			<not>
			«FOR ntp:ct.not.patterns»
				<pattern>«ntp»</pattern>
			«ENDFOR»
			</not>
		«ENDIF»
		</combination>	
	'''
	
	def compile(OrType ot) '''
		<or>
		«FOR otp:ot.patterns»
			<pattern>«otp»</pattern>
		«ENDFOR»
		</or>
	'''
	
	
}
