/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui;

import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.util.ui.navigator.ProjectExplorerUtil;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WorkspaceUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "it.jrc.osint.workspace.ui";
    private static WorkspaceUIPlugin plugin;
    private EventBroker eventBroker;
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.eventBroker = new EventBroker(context);
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = cmdService.getCommand("osint.command.extract.toggleAutomaticExtraction");
        State state = cmd.getState("org.eclipse.ui.commands.toggleState");
        boolean enabled = (Boolean)state.getValue();
        WorkspaceUIPlugin.getWorkspaceService().enableAutomaticExtraction(enabled);
        this.eventBroker.register(new String[]{"osint/workspace/refreshUI", "osint/workspace/metaDataChanged", "osint/workspace/projectCleanBuildFinished"}, this.topicEventListener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.eventBroker != null) {
            this.eventBroker.stop();
        }
        plugin = null;
        super.stop(context);
    }

    public static WorkspaceUIPlugin getPlugin() {
        return plugin;
    }

    public static WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getWorkspaceService();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("open_config_project", WorkspaceUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/custom/config_prj_obj.png"));
        reg.put("closed_config_project", WorkspaceUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/custom/c_config_prj_obj.png"));
        reg.put("config_overlay", WorkspaceUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/custom/overlay/config_prj_ov.png"));
        reg.put("docfolder_overlay", WorkspaceUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/custom/overlay/doc_folder_ov.png"));
        reg.put("workset", WorkspaceUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/custom/workset.png"));
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if ("osint/workspace/metaDataChanged".equals(event.getTopic())) {
                ProjectExplorerUtil.refresh();
                return;
            }
            if ("osint/workspace/projectCleanBuildFinished".equals(event.getTopic())) {
                ProjectExplorerUtil.refresh();
                return;
            }
            if ("osint/workspace/refreshUI".equals(event.getTopic())) {
                ProjectExplorerUtil.refresh();
                return;
            }
        }
    }
}

