/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.navigator;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.LabelProviderAdapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import org.eclipse.core.resources.IFile;

public class DocumentTitleLabelProvider
extends LabelProviderAdapter {
    private static final Logger log = LogManager.getLogger((String)DocumentTitleLabelProvider.class.getName());

    public String getText(Object element) {
        if (element instanceof IFile) {
            String title;
            IFile file = (IFile)element;
            if (!file.exists()) {
                return "";
            }
            String label = file.getName();
            String projectName = file.getProject().getName();
            WorkspaceService ws = WorkspacePlugin.getWorkspaceService();
            ResourceId id = ws.getId(file.getFullPath());
            CaseProject cp = ws.getCaseProjectByName(projectName);
            if (cp == null) {
                return label;
            }
            DocumentMetaItem dmi = cp.getMetaItem(id);
            if (dmi != null && (title = dmi.getTitle()) != null && !"".equals(title)) {
                label = title;
            }
            return label;
        }
        return null;
    }
}

