/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.ui.wizard.NewCaseProjectCreationPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class NewCaseProjectWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "it.jrc.osint.ui.wizards.new.caseProject";
    private static final Logger log = LogManager.getLogger((String)NewCaseProjectWizard.class.getName());
    private NewCaseProjectCreationPage projectCreationPage;
    private IProject newProject;

    public boolean performFinish() {
        String projectName = this.projectCreationPage.getProjectName();
        IProject newProject = this.createNewProject(projectName);
        return newProject != null;
    }

    public void addPages() {
        super.addPages();
        this.projectCreationPage = new NewCaseProjectCreationPage("createProjectPage");
        this.addPage((IWizardPage)this.projectCreationPage);
    }

    private IProject createNewProject(String newProjectName) {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject createProject = this.projectCreationPage.getProjectHandle();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(createProject.getName());
        description.setLocationURI(null);
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = "it.jrc.osint.workspace.caseProjectNature";
        description.setNatureIds(newNatures);
        ICommand[] nc = new ICommand[1];
        ICommand cmd1 = description.newCommand();
        cmd1.setBuilderName("it.jrc.osint.workspace.caseProjectBuilder");
        nc[0] = cmd1;
        description.setBuildSpec(nc);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CreateProjectOperation op = new CreateProjectOperation(description, "Create new OSINT Project");
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)NewCaseProjectWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            log.error("Project creation interrupted", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error("Failed to create new case project", (Throwable)e);
            return null;
        }
        this.newProject = createProject;
        if (this.newProject.exists()) {
            log.debug("New project exists");
        }
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
    }
}

