/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.workspace.ui.wizard.NewConfigProjectCreationPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class NewConfigProjectWizard
extends Wizard
implements INewWizard {
    private static final Logger log = LogManager.getLogger((String)NewConfigProjectWizard.class.getName());
    public static final String WIZARD_ID = "it.jrc.osint.ui.wizards.new.configProject";
    private NewConfigProjectCreationPage mainPage;
    private IProject newProject;

    public boolean performFinish() {
        String projectName = this.mainPage.getProjectName();
        IProject newProject = this.createNewProject(projectName);
        return newProject != null;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewConfigProjectCreationPage("createProjectPage");
        this.addPage((IWizardPage)this.mainPage);
    }

    private IProject createNewProject(String newProjectName) {
        if (this.newProject != null) {
            return this.newProject;
        }
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IProject createProject = this.mainPage.getProjectHandle();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(createProject.getName());
        description.setLocationURI(location);
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 2];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = "org.eclipse.xtext.ui.shared.xtextNature";
        newNatures[prevNatures.length + 1] = "it.jrc.osint.workspace.configProjectNature";
        description.setNatureIds(newNatures);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CreateProjectOperation op = new CreateProjectOperation(description, "Create new Configuration Project");
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)NewConfigProjectWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException e) {
            log.error("Project creation interrupted", (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error("Failed to create new config project", (Throwable)e);
            return null;
        }
        this.newProject = createProject;
        if (this.newProject.exists()) {
            log.debug("New project exists");
        }
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
    }
}

