/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.FilteringAutomatonInstance;

public final class FilteringAutomatonInstanceArrayList {
    private transient FilteringAutomatonInstance[] elementData;
    private int size;
    private int minCapacity;

    public FilteringAutomatonInstanceArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new FilteringAutomatonInstance[initialCapacity];
    }

    public FilteringAutomatonInstanceArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            FilteringAutomatonInstance[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new FilteringAutomatonInstance[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public FilteringAutomatonInstance get(int index) {
        return this.elementData[index];
    }

    public void set(int index, FilteringAutomatonInstance value) {
        this.elementData[index] = new FilteringAutomatonInstance(value);
    }

    public boolean add(FilteringAutomatonInstance o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            FilteringAutomatonInstance[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new FilteringAutomatonInstance[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public FilteringAutomatonInstance removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public FilteringAutomatonInstance remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        FilteringAutomatonInstance temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }
}

