/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs;

import it.jrc.lt.regexpfs.InputFeatureStructure;
import java.util.Arrays;
import java.util.Comparator;

public class InputFSArrayList {
    private transient InputFeatureStructure[] elementData;
    private int size;
    private int minCapacity;

    public InputFSArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new InputFeatureStructure[initialCapacity];
    }

    public InputFSArrayList() {
        this(10);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            InputFeatureStructure[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new InputFeatureStructure[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public InputFeatureStructure get(int index) {
        return this.elementData[index];
    }

    public void set(int index, InputFeatureStructure value) {
        this.elementData[index] = new InputFeatureStructure(value);
    }

    public boolean add(InputFeatureStructure o) {
        if (this.size + 1 > this.elementData.length) {
            this.minCapacity = this.size + 1;
            int oldCapacity = this.elementData.length;
            InputFeatureStructure[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < this.minCapacity) {
                newCapacity = this.minCapacity;
            }
            this.elementData = new InputFeatureStructure[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = o;
        return true;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public InputFeatureStructure removeLast() {
        if (this.size > 0) {
            --this.size;
        }
        return this.elementData[this.size];
    }

    public InputFeatureStructure remove(int index) {
        if (index == this.size - 1) {
            return this.removeLast();
        }
        InputFeatureStructure temp = this.elementData[index];
        this.elementData[index] = this.elementData[--this.size];
        return temp;
    }

    public void clear() {
        this.size = 0;
    }

    public void sort(Comparator<InputFeatureStructure> myComparator) {
        if (this.size < 2) {
            return;
        }
        Arrays.sort(this.elementData, 0, this.size, myComparator);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("InputFeatureStructures:");
        out.append('\n');
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            out.append(this.get(i).toString());
            out.append('\n');
        }
        return out.toString();
    }
}

