/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.application;

import it.jrc.lt.regexpfs.GrammarInterpreter;
import it.jrc.lt.regexpfs.InputFSDArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.InputFeatureStructureDisjunction;
import it.jrc.lt.regexpfs.application.MatchStatistic;
import it.jrc.lt.regexpfs.application.MatchStatisticComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import piskorski.util.arraylist.StringArrayList;
import piskorski.util.functions.Files;

public class ComputeMatchesAndStatistics {
    public static StringArrayList returnStats(HashMap<String, Integer> myStats) {
        if (myStats == null) {
            return null;
        }
        Set<String> myKeys = myStats.keySet();
        MatchStatistic[] stats = new MatchStatistic[myKeys.size()];
        int count = 0;
        for (String key : myKeys) {
            stats[count++] = new MatchStatistic(key, myStats.get(key));
        }
        if (stats.length > 1) {
            Arrays.sort(stats, 0, stats.length, MatchStatisticComparator.getInstance());
        }
        int len = stats.length;
        StringArrayList myList = new StringArrayList(len);
        for (int i = 0; i < len; ++i) {
            myList.add(stats[i].toString());
        }
        return myList;
    }

    public static void main(String[] args) {
        HashMap<String, HashMap<String, Integer>> stats = new HashMap<String, HashMap<String, Integer>>();
        String configurationFile = args[0];
        String statsFile = args[1];
        GrammarInterpreter gInterpreter = new GrammarInterpreter();
        Properties confProperties = gInterpreter.readProperties(configurationFile);
        if (gInterpreter.launch(confProperties)) {
            String InputFileDirectory = confProperties.getProperty("InputFileDirectory", null);
            String CharacterSet = confProperties.getProperty("CharacterSet", "UTF-8");
            ArrayList myFiles = new ArrayList();
            boolean status = Files.readFileNamesFromDirectory((String)InputFileDirectory, myFiles);
            if (!status) {
                System.out.println("Problem encountered while accessing the directory" + InputFileDirectory);
                System.exit(0);
            }
            int len = myFiles.size();
            for (int i = 0; i < len; ++i) {
                File f = (File)myFiles.get(i);
                String myInput = null;
                try {
                    myInput = Files.FileToString((String)f.getAbsolutePath(), (String)CharacterSet);
                }
                catch (Exception e) {
                    System.out.println("Problems while reading/accessing file: " + f.getAbsolutePath());
                    continue;
                }
                System.out.println("Processing file: " + i + ": " + f.getAbsolutePath());
                InputFSDArrayList result = gInterpreter.applyOnText(myInput.toCharArray());
                if (result == null) continue;
                int numDisj = result.size();
                for (int k = 0; k < numDisj; ++k) {
                    InputFeatureStructureDisjunction currentDisj = result.get(k);
                    int sizeDisj = currentDisj.getLen();
                    for (int j = 0; j < sizeDisj; ++j) {
                        Integer num;
                        InputFeatureStructure currentFs = currentDisj.getFeatureStructure(j);
                        int start = currentFs.getStart();
                        int end = currentFs.getEnd();
                        StringTokenizer sT = new StringTokenizer(myInput.substring(start, end + 1), " \t\n\r");
                        StringBuffer content = new StringBuffer();
                        while (sT.hasMoreTokens()) {
                            content.append(sT.nextToken());
                            content.append(" ");
                        }
                        String cont = content.toString();
                        String typeName = gInterpreter.getTypeName(currentFs.getType());
                        HashMap<String, Integer> statsMap = (HashMap<String, Integer>)stats.get(typeName);
                        if (statsMap == null) {
                            HashMap<String, Integer> newMap = new HashMap<String, Integer>();
                            stats.put(typeName, newMap);
                            statsMap = newMap;
                        }
                        if ((num = (Integer)statsMap.get(cont)) != null) {
                            statsMap.put(cont, num + 1);
                            continue;
                        }
                        statsMap.put(cont, new Integer(1));
                    }
                }
            }
            Set myTypes = stats.keySet();
            for (String myType : myTypes) {
                StringArrayList resultsForFile = ComputeMatchesAndStatistics.returnStats((HashMap)stats.get(myType));
                Files.StringArrayListToFile((String)(statsFile + "_" + myType + ".txt"), (StringArrayList)resultsForFile, (String)CharacterSet);
            }
        } else {
            System.out.println("Problem while launching grammar Interpreter from file: " + configurationFile);
            System.exit(0);
        }
    }
}

