/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.booleanOperator;

import it.jrc.lt.regexpfs.booleanOperator.BooleanOperator;
import piskorski.util.strings.StringFunctions;

public class ValidEmail
extends BooleanOperator {
    private boolean isValidUserName(String user) {
        int lenL = user.length();
        if (lenL == 0 || lenL > 64) {
            return false;
        }
        for (int i = 0; i < lenL; ++i) {
            char c = user.charAt(i);
            if (c != '.' || i <= 0) continue;
            if (user.charAt(i - 1) == '.') {
                return false;
            }
            if (user.charAt(i - 1) == '-') {
                return false;
            }
            if (i >= lenL - 1 || user.charAt(i + 1) != '-') continue;
            return false;
        }
        return true;
    }

    private boolean isValidDomainName(String domain) {
        int lenD = domain.length();
        if (lenD == 0 || lenD > 254) {
            return false;
        }
        for (int i = 0; i < lenD; ++i) {
            char c = domain.charAt(i);
            if (c != '.' || i <= 0) continue;
            if (domain.charAt(i - 1) == '.') {
                return false;
            }
            if (domain.charAt(i - 1) == '-') {
                return false;
            }
            if (i >= lenD - 1 || domain.charAt(i + 1) != '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean computeValue(String[] args) {
        if (args == null) {
            return false;
        }
        if (args.length != 2) {
            return false;
        }
        String user = StringFunctions.removeWhitespaces((String)args[0]);
        String domain = StringFunctions.removeWhitespaces((String)args[1]);
        if (user == null || domain == null) {
            return false;
        }
        return this.isValidUserName(user) && this.isValidDomainName(domain);
    }

    @Override
    public String getName() {
        return "ValidEmail";
    }
}

