/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.booleanOperator;

import it.jrc.lt.regexpfs.booleanOperator.BooleanOperator;
import java.math.BigInteger;
import java.util.HashMap;
import piskorski.util.language.ISO2CountryCode;
import piskorski.util.strings.StringFunctions;

public class ValidIBAN
extends BooleanOperator {
    private static HashMap<ISO2CountryCode, IBANCountryFormat> IBAN_Format;

    public ValidIBAN() {
        IBAN_Format = new HashMap();
        IBAN_Format.put(ISO2CountryCode.ANDORRA, new IBANCountryFormat("", "nnnnnnnncccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.ALBANIA, new IBANCountryFormat("", "nnnnnnnncccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.AUSTRIA, new IBANCountryFormat("", "nnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.AZERBAIJAN, new IBANCountryFormat("", "ccccnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.BELGIUM, new IBANCountryFormat("", "nnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.BOSNIA_AND_HERZEGOVINA, new IBANCountryFormat("39", "nnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.BRAZIL, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnnnnnac"));
        IBAN_Format.put(ISO2CountryCode.BAHRAIN, new IBANCountryFormat("", "aaaacccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.BULGARIA, new IBANCountryFormat("", "aaaannnnnncccccccc"));
        IBAN_Format.put(ISO2CountryCode.COSTA_RICA, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.CROATIA, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.CYPRUS, new IBANCountryFormat("", "nnnnnnnncccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.CZECH_REPUBLIC, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.DENMARK, new IBANCountryFormat("", "nnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.DOMINICAN_REPUBLIC, new IBANCountryFormat("", "aaaannnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.EAST_TIMOR, new IBANCountryFormat("38", "nnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.ESTONIA, new IBANCountryFormat("", "nnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.FAROE_ISLANDS, new IBANCountryFormat("", "nnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.FINLAND, new IBANCountryFormat("", "nnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.FRANCE, new IBANCountryFormat("", "nnnnnnnnnncccccccccccnn"));
        IBAN_Format.put(ISO2CountryCode.GEORGIA, new IBANCountryFormat("", "ccnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.GERMANY, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.GIBRALTAR, new IBANCountryFormat("", "aaaaccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.GREECE, new IBANCountryFormat("", "nnnnnnncccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.GREENLAND, new IBANCountryFormat("", "nnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.GUATEMALA, new IBANCountryFormat("", "cccccccccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.HUNGARY, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.ICELAND, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.IRELAND, new IBANCountryFormat("", "ccccnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.ISRAEL, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.ITALY, new IBANCountryFormat("", "annnnnnnnnncccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.JORDAN, new IBANCountryFormat("", "aaaannnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.KAZAKHSTAN, new IBANCountryFormat("", "nnnccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.KOSOVO, new IBANCountryFormat("", "nnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.KUWAIT, new IBANCountryFormat("", "aaaacccccccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.LATVIA, new IBANCountryFormat("", "aaaaccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.LEBANON, new IBANCountryFormat("", "nnnncccccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.LIECHTENSTEIN, new IBANCountryFormat("", "nnnnncccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.LITHUANIA, new IBANCountryFormat("", "nnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.LUXEMBOURG, new IBANCountryFormat("", "nnnccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.MACEDONIA, new IBANCountryFormat("07", "nnnccccccccccnn"));
        IBAN_Format.put(ISO2CountryCode.MALTA, new IBANCountryFormat("", "aaaannnnncccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.MAURITANIA, new IBANCountryFormat("13", "nnnnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.MAURITIUS, new IBANCountryFormat("", "aaaannnnnnnnnnnnnnnnnnnaaa"));
        IBAN_Format.put(ISO2CountryCode.MONACO, new IBANCountryFormat("", "nnnnnnnnnncccccccccccnn"));
        IBAN_Format.put(ISO2CountryCode.MOLDOVA, new IBANCountryFormat("", "cccccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.MONTENEGRO, new IBANCountryFormat("25", "nnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.NETHERLANDS, new IBANCountryFormat("", "aaaannnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.NORWAY, new IBANCountryFormat("", "nnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.PAKISTAN, new IBANCountryFormat("", "ccccnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.PALESTINE, new IBANCountryFormat("", "ccccnnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.POLAND, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.PORTUGAL, new IBANCountryFormat("50", "nnnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.QUATAR, new IBANCountryFormat("", "aaaaccccccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.ROMANIA, new IBANCountryFormat("", "aaaacccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.SAN_MARINO, new IBANCountryFormat("", "annnnnnnnnncccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.SAUDI_ARABIA, new IBANCountryFormat("", "nncccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.SERBIA, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.SLOVAKIA, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.SLOVENIA, new IBANCountryFormat("56", "nnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.SPAIN, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.SWEDEN, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.SWITZERLAND, new IBANCountryFormat("", "nnnnncccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.TUNISIA, new IBANCountryFormat("59", "nnnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.TURKEY, new IBANCountryFormat("", "nnnnnccccccccccccccccc"));
        IBAN_Format.put(ISO2CountryCode.UNITED_ARAB_EMIRATES, new IBANCountryFormat("", "nnnnnnnnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.UNITED_KINGDOM, new IBANCountryFormat("", "aaaannnnnnnnnnnnnn"));
        IBAN_Format.put(ISO2CountryCode.VIRGIN_ISLANDS_BRITISH, new IBANCountryFormat("", "ccccnnnnnnnnnnnnnnnn"));
    }

    @Override
    public String getName() {
        return "ValidIBAN";
    }

    private boolean validateIBAN(ISO2CountryCode myCountry, String check_digits, String bban) {
        if (myCountry == null) {
            return false;
        }
        IBANCountryFormat myFormat = IBAN_Format.get(myCountry);
        if (myFormat == null) {
            return false;
        }
        int len = bban.length();
        if (myFormat.length != len) {
            return false;
        }
        if (myFormat.check_digit.length > 0) {
            if (check_digits.length() != 2) {
                return false;
            }
            if (check_digits.charAt(0) != myFormat.check_digit[0] || check_digits.charAt(1) != myFormat.check_digit[1]) {
                return false;
            }
        }
        block5: for (int i = 0; i < len; ++i) {
            char inputC = bban.charAt(i);
            char formatC = myFormat.format[i];
            switch (formatC) {
                case 'n': {
                    if (StringFunctions.isLatinDigit((char)inputC)) continue block5;
                    return false;
                }
                case 'a': {
                    if (StringFunctions.isUpperCaseLatin((char)inputC)) continue block5;
                    return false;
                }
                case 'c': {
                    if (StringFunctions.isLatinLettersOrDigits((char)inputC)) continue block5;
                    return false;
                }
            }
        }
        return true;
    }

    boolean modulo97Test(String country, String check_digits, String bban) {
        StringBuffer sB = new StringBuffer();
        int len = bban.length();
        for (int i = 0; i < len; ++i) {
            char c = bban.charAt(i);
            if (StringFunctions.isLatinDigit((char)c)) {
                sB.append(c);
                continue;
            }
            sB.append(Character.toUpperCase(c) - 65 + 10);
        }
        sB.append(country.charAt(0) - 65 + 10);
        sB.append(country.charAt(1) - 65 + 10);
        sB.append(check_digits);
        BigInteger myIban = new BigInteger(sB.toString());
        return myIban.remainder(BigInteger.valueOf(97L)).intValue() == 1;
    }

    @Override
    public boolean computeValue(String[] args) {
        if (args == null) {
            return false;
        }
        if (args.length != 3) {
            return false;
        }
        String country = args[0];
        String check_digits = args[1];
        String bban = args[2];
        if (country == null || check_digits == null || bban == null) {
            return false;
        }
        if (!this.validateIBAN(ISO2CountryCode.getCountryCode((String)country), check_digits, bban)) {
            return false;
        }
        return this.modulo97Test(country, check_digits, bban);
    }

    private final class IBANCountryFormat {
        char[] check_digit;
        int length;
        char[] format;

        IBANCountryFormat(String check_digit, String format) {
            this.check_digit = check_digit.toCharArray();
            this.format = format.toCharArray();
            this.length = format.length();
        }
    }
}

