/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.funop;

import it.jrc.lt.regexpfs.funop.FunctionalOperator;
import java.util.HashMap;

public class CreditCardIssuer
extends FunctionalOperator {
    private static HashMap<String, CardSpecifics> issuers;

    public CreditCardIssuer() {
        issuers = new HashMap();
        issuers.put("4", new CardSpecifics(13, 16, "Visa"));
        issuers.put("51", new CardSpecifics(16, 19, "MasterCard"));
        issuers.put("52", new CardSpecifics(16, 19, "MasterCard"));
        issuers.put("53", new CardSpecifics(16, 19, "MasterCard"));
        issuers.put("54", new CardSpecifics(16, 19, "MasterCard"));
        issuers.put("55", new CardSpecifics(16, 19, "MasterCard"));
        issuers.put("34", new CardSpecifics(15, 15, "AmericanExpress"));
        issuers.put("37", new CardSpecifics(15, 15, "AmericanExpress"));
        issuers.put("36", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("38", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("39", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("300", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("301", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("302", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("303", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("304", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("305", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("309", new CardSpecifics(14, 14, "DinersClub"));
        issuers.put("6011", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("622", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("644", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("645", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("646", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("647", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("648", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("649", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("65", new CardSpecifics(16, 19, "DiscoverCard"));
        issuers.put("636", new CardSpecifics(16, 19, "InterPayment"));
        issuers.put("637", new CardSpecifics(16, 16, "InstaPayment"));
        issuers.put("638", new CardSpecifics(16, 16, "InstaPayment"));
        issuers.put("639", new CardSpecifics(16, 16, "InstaPayment"));
        issuers.put("5018", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("5020", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("5038", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("5893", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("6304", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("6759", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("6761", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("6762", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("6763", new CardSpecifics(16, 19, "Maestro"));
        issuers.put("1", new CardSpecifics(15, 15, "UATP"));
        issuers.put("35", new CardSpecifics(16, 16, "JCB"));
        issuers.put("6304", new CardSpecifics(16, 19, "Laser"));
        issuers.put("6706", new CardSpecifics(16, 19, "Laser"));
        issuers.put("6771", new CardSpecifics(16, 19, "Laser"));
        issuers.put("6709", new CardSpecifics(16, 19, "Laser"));
        issuers.put("62", new CardSpecifics(16, 19, "ChinaUnionPay"));
    }

    @Override
    public String getName() {
        return "CreditCardIssuer ";
    }

    @Override
    public String computeValue(String[] args) {
        if (args == null) {
            return "";
        }
        if (args.length != 1) {
            return "";
        }
        String card = args[0];
        int len = card.length();
        if (len < 12) {
            return "Other";
        }
        for (int i = 6; i > 0; --i) {
            String currentPrefix = card.substring(0, i);
            CardSpecifics cSpec = issuers.get(currentPrefix);
            if (cSpec == null || len < cSpec.minLen || len > cSpec.maxLen) continue;
            return cSpec.name;
        }
        return "Other";
    }

    private final class CardSpecifics {
        int minLen;
        int maxLen;
        String name;

        CardSpecifics(int min, int max, String name) {
            this.minLen = min;
            this.maxLen = max;
            this.name = name;
        }
    }
}

