/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.tokenizer.AbstractTokenItem;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public final class CorleoneClassifyingTokenizer
extends Module {
    private static short TOKEN = 0;
    private static short TOKEN_TYPE = 0;
    private static short TOKEN_STRING = 1;
    private static String[] tokenizerTypes = new String[]{"token"};
    private static String[][] tokenizerAttrributes = new String[][]{{"TYPE", "SURFACE"}};
    private static ArrayList<String> tokenizerTypesList = new ArrayList();
    private static HashMap<String, ArrayList<String>> tokenizerAttributeLists = new HashMap();
    private AbstractTokenizer tokenizer = AbstractTokenizer.createInstance((String)"classifyingTokenizer");

    protected CorleoneClassifyingTokenizer() {
    }

    @Override
    protected InputFSArrayList convertResult(Object o, char[] inputText) {
        if (o == null) {
            return null;
        }
        ArrayList tokens = (ArrayList)o;
        int numTokens = tokens.size();
        InputFSArrayList result = new InputFSArrayList(numTokens);
        for (int i = 0; i < numTokens; ++i) {
            InputFeatureStructure fs = new InputFeatureStructure();
            AbstractTokenItem token = (AbstractTokenItem)tokens.get(i);
            int start = token.getStart();
            int end = token.getEnd();
            fs.setPosition(start, end);
            fs.setType(TOKEN);
            fs.initializeAttributes((byte)2);
            if (token.getType() == 0) {
                fs.setAttribute(TOKEN_TYPE, "undefined");
            } else {
                fs.setAttribute(TOKEN_TYPE, token.getTypeAsString());
            }
            String surface = new String(inputText, start, end - start + 1);
            fs.setAttribute(TOKEN_STRING, surface);
            result.add(fs);
        }
        return result;
    }

    @Override
    protected ArrayList<String> getAttributeNames(String type) {
        return tokenizerAttributeLists.get(type);
    }

    @Override
    protected ArrayList<String> getTypes() {
        return tokenizerTypesList;
    }

    @Override
    protected boolean initialize() {
        Properties myProperties = this.getModulesConfiguration();
        String TokenizerFile = myProperties.getProperty("ResourceFile");
        if (TokenizerFile == null) {
            Module.loggerMessage("Missing property: \"" + TokenizerFile + "\" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        boolean status = this.tokenizer.readFromFile(TokenizerFile);
        if (!status) {
            Module.loggerMessage("Could not initialize the module: " + this.getComponentName() + " via reading the file: " + TokenizerFile);
            return false;
        }
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage("Could not initialize the configuration for the module: " + this.getComponentName());
            return false;
        }
        return this.tokenizer.applySettings(myConfig);
    }

    @Override
    protected Object performTask(char[] inputText, ResultPool resultPool) throws ProcessingException {
        ArrayList results = this.tokenizer.tokenize(inputText);
        if (results == null) {
            throw new ProcessingException("Problem encountered while running the component: " + this.getComponentName());
        }
        return results;
    }

    static {
        int numTypes = tokenizerTypes.length;
        for (int i = 0; i < numTypes; ++i) {
            tokenizerTypesList.add(tokenizerTypes[i]);
            ArrayList<String> attributesForType = new ArrayList<String>();
            int numAttributes = tokenizerAttrributes[i].length;
            for (int j = 0; j < numAttributes; ++j) {
                attributesForType.add(tokenizerAttrributes[i][j]);
            }
            tokenizerAttributeLists.put(tokenizerTypes[i], attributesForType);
        }
    }
}

