/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.lt.regexpfs.module;

import it.jrc.lt.core.component.Configuration;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractDisjunctionOfFlatPatternMatcherItems;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractFlatPatternMatcher;
import it.jrc.lt.core.component.flatpatternmatcher.AbstractFlatPatternMatcherItem;
import it.jrc.lt.core.component.flatpatternmatcher.TokenTagger;
import it.jrc.lt.core.component.tokenizer.AbstractTokenizer;
import it.jrc.lt.regexpfs.InputFSArrayList;
import it.jrc.lt.regexpfs.InputFeatureStructure;
import it.jrc.lt.regexpfs.module.Module;
import it.jrc.lt.regexpfs.module.ProcessingException;
import it.jrc.lt.regexpfs.results.ResultPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class CorleoneFlatPatternMatcher
extends Module {
    private static short TOKEN_CHUNK = 0;
    private static short ATTR_SURFACE = 0;
    private static short ATTR_TYPE = 1;
    private static short ATTR_SUBTYPE = (short)2;
    private static String[] patternMatcherTypes = new String[]{"token_chunk"};
    private static String[][] patternMatcherAttrributes = new String[][]{{"SURFACE", "TYPE", "SUBTYPE"}};
    private static ArrayList<String> patternMatcherTypesList = new ArrayList();
    private static HashMap<String, ArrayList<String>> patternMatcherAttributeLists = new HashMap();
    private AbstractFlatPatternMatcher patternMatcher = AbstractFlatPatternMatcher.createInstance((String)"basicFlatPatternMatcher");
    private TokenTagger tokenTagger = null;
    private AbstractTokenizer tokenizer = null;
    private static final String RESOURCE_FILE = "ResourceFile";
    private static final String TOKENIZER_RESOURCE_FILE = "TokenizerResourceFile";
    private static final String TOKENIZER_PRODUCES_WHITESPACES = "TokenizerProducesWhitespaces";
    private static final String TOKENTAGGER = "TokenTagger";
    private static final String TOKENTAGGER_CONFIGURATION_FILE = "TokenTaggerConfigurationFile";

    @Override
    protected boolean initialize() {
        Properties myProperties = this.getModulesConfiguration();
        this.tokenizer = AbstractTokenizer.createInstance((String)"basicTokenizer");
        String tokenizerFile = myProperties.getProperty(TOKENIZER_RESOURCE_FILE, "");
        String producesWhitespaces = myProperties.getProperty(TOKENIZER_PRODUCES_WHITESPACES, "true");
        if (tokenizerFile.compareTo("") != 0) {
            boolean status = this.tokenizer.readFromFile(tokenizerFile);
            if (!status) {
                Module.loggerMessage("Could not initialize the tokenizer for module: " + this.getComponentName() + " via reading the file: " + tokenizerFile);
                return false;
            }
        } else {
            Module.loggerMessage("Missing property: TokenizerResourceFile in configuration file of the module: " + this.getComponentName());
            return false;
        }
        if (producesWhitespaces.compareTo("true") == 0) {
            this.tokenizer.produceWhitespaceTokens();
        }
        if (this.tokenizer.isNullComponent() || !this.tokenizer.hasBeenInitialized()) {
            Module.loggerMessage("Problems encountered while initializing the tokenizer for module: " + this.getComponentName());
            return false;
        }
        String tokenTaggerName = myProperties.getProperty(TOKENTAGGER, "");
        String tokenTaggerFile = myProperties.getProperty(TOKENTAGGER_CONFIGURATION_FILE, "");
        this.tokenTagger = TokenTagger.getInstance((String)tokenTaggerName);
        if (this.tokenTagger == null) {
            Module.loggerMessage("Could not initialize the tagger named: " + tokenTaggerName + " while launching the flat pattern matcher");
            return false;
        }
        if (!this.tokenTagger.initialize(tokenTaggerFile)) {
            Module.loggerMessage("Could not initialize the tagger named: " + tokenTaggerName + " while reading the configuration file: " + tokenTaggerFile);
            return false;
        }
        String MatcherFile = myProperties.getProperty(RESOURCE_FILE);
        if (MatcherFile == null) {
            Module.loggerMessage("Missing property: \"ResourceFile\" in configuration file of the module: " + this.getComponentName());
            return false;
        }
        this.patternMatcher = AbstractFlatPatternMatcher.createInstance((String)"basicFlatPatternMatcher");
        boolean status = this.patternMatcher.readFromFile(MatcherFile);
        if (!status) {
            Module.loggerMessage("Could not initialize the module: " + this.getComponentName() + " via reading the file: " + MatcherFile);
            return false;
        }
        Configuration myConfig = Configuration.initializeFrom((Properties)myProperties);
        if (myConfig.isNull()) {
            Module.loggerMessage("Could not initialize the configuration for the module: " + this.getComponentName());
            return false;
        }
        status = this.patternMatcher.applySettings(myConfig);
        this.patternMatcher.returnCharacterPositions();
        return status && !this.patternMatcher.isNullComponent() && this.patternMatcher.hasBeenInitialized();
    }

    protected CorleoneFlatPatternMatcher() {
    }

    @Override
    protected ArrayList<String> getTypes() {
        return patternMatcherTypesList;
    }

    @Override
    protected ArrayList<String> getAttributeNames(String type) {
        return patternMatcherAttributeLists.get(type);
    }

    private String extractProperSurfaceForm(char[] text, int start, int end) {
        int len = end - start + 1;
        char[] surface = new char[len];
        boolean readWhitespaces = false;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char c = text[start + i];
            if (Character.isWhitespace(c)) {
                if (readWhitespaces) continue;
                readWhitespaces = true;
                surface[count++] = 32;
                continue;
            }
            readWhitespaces = false;
            surface[count++] = c;
        }
        return new String(surface, 0, count);
    }

    @Override
    protected InputFSArrayList convertResult(Object o, char[] inputText) {
        if (o == null) {
            return null;
        }
        ArrayList tokenChunks = (ArrayList)o;
        int numPatternMatcherObjects = tokenChunks.size();
        InputFSArrayList results = new InputFSArrayList(tokenChunks.size());
        for (int i = 0; i < numPatternMatcherObjects; ++i) {
            AbstractDisjunctionOfFlatPatternMatcherItems singleResult = (AbstractDisjunctionOfFlatPatternMatcherItems)tokenChunks.get(i);
            int singleResultSize = singleResult.getNumberOfItems();
            for (int j = 0; j < singleResultSize; ++j) {
                AbstractFlatPatternMatcherItem res = singleResult.getItem(j);
                InputFeatureStructure fs = new InputFeatureStructure();
                fs.setType(TOKEN_CHUNK);
                int start = res.getStart();
                int end = res.getEnd();
                String surface = this.extractProperSurfaceForm(inputText, start, end);
                fs.setPosition(start, end);
                fs.initializeAttributes((byte)this.attributes[TOKEN_CHUNK].length);
                fs.setAttribute(ATTR_SURFACE, surface);
                fs.setAttribute(ATTR_TYPE, res.getTypeAsString());
                fs.setAttribute(ATTR_SUBTYPE, res.getSubTypeAsString());
                results.add(fs);
            }
        }
        return results;
    }

    @Override
    protected Object performTask(char[] text, ResultPool myResult) throws ProcessingException {
        ArrayList tokens = null;
        try {
            tokens = this.tokenizer.tokenize(text);
        }
        catch (Exception e) {
            Module.loggerMessage(e.getMessage());
            throw new ProcessingException("Processing exception while running a tokenizer by: " + this.getComponentName());
        }
        ArrayList matchItems = null;
        if (tokens != null) {
            matchItems = this.patternMatcher.findMatch(tokens, text, this.tokenTagger);
        }
        return matchItems;
    }

    static {
        int numTypes = patternMatcherTypes.length;
        for (int i = 0; i < numTypes; ++i) {
            patternMatcherTypesList.add(patternMatcherTypes[i]);
            ArrayList<String> attributesForType = new ArrayList<String>();
            int numAttributes = patternMatcherAttrributes[i].length;
            for (int j = 0; j < numAttributes; ++j) {
                attributesForType.add(patternMatcherAttrributes[i][j]);
            }
            patternMatcherAttributeLists.put(patternMatcherTypes[i], attributesForType);
        }
    }
}

