/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util;

import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class EventSourceSupport<T extends EventListener>
implements Iterable<T> {
    private Set<T> listeners = new HashSet<T>();

    public void addEventListener(T aListener) {
        if (aListener == null) {
            return;
        }
        if (!this.listeners.contains(aListener)) {
            this.listeners.add(aListener);
        }
    }

    public void removeEventListener(T aListener) {
        if (aListener == null) {
            return;
        }
        if (this.listeners.contains(aListener)) {
            this.listeners.remove(aListener);
        }
    }

    @Override
    public Iterator<T> iterator() {
        Object[] array = this.listeners.toArray();
        ArrayIterator iterator = new ArrayIterator(array);
        return iterator;
    }

    public class ArrayIterator
    implements Iterator<T> {
        private Object[] array;
        private int index = 0;
        private boolean lastRemoved = false;

        public ArrayIterator(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public T next() throws NoSuchElementException {
            if (this.index >= this.array.length) {
                throw new NoSuchElementException("Array index " + this.index + " out of array size: " + this.array.length);
            }
            EventListener object = (EventListener)this.array[this.index];
            ++this.index;
            this.lastRemoved = false;
            return object;
        }

        @Override
        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException("You need to call next() at least once before remove");
            }
            if (this.lastRemoved) {
                throw new IllegalStateException("You need to call next() at least once before calling remove again");
            }
            this.array[this.index - 1] = null;
            this.lastRemoved = true;
        }
    }
}

