/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.URLFilter;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLUtil {
    private static final Logger log = LogManager.getLogger((String)URLUtil.class.getName());
    public static URLFilter NULL_FILTER = new NullFilter();

    public static URLFilter createFilter(List<String> regexPatterns) {
        return new MultiplePatternFilter(regexPatterns);
    }

    public static URLFilter createFilter(String[] regexPatterns) {
        return new MultiplePatternFilter(regexPatterns);
    }

    public static String getDomainName(String url) {
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            return domain.startsWith("www.") ? domain.substring(4) : domain;
        }
        catch (Throwable t) {
            log.error("Failed to parse URL " + url);
            return null;
        }
    }

    private static class MultiplePatternFilter
    implements URLFilter {
        private Set<Pattern> patternSet = new HashSet<Pattern>();

        public MultiplePatternFilter(List<String> regexPatterns) {
            for (String pattern : regexPatterns) {
                try {
                    Pattern p = Pattern.compile(pattern);
                    this.patternSet.add(p);
                }
                catch (Throwable t) {
                    log.error("Failed to compile pattern: " + pattern, t);
                }
            }
        }

        public MultiplePatternFilter(String[] regexPatterns) {
            this(Arrays.asList(regexPatterns));
        }

        @Override
        public boolean matches(String URL2) {
            if (URL2 == null) {
                return true;
            }
            if (this.patternSet.isEmpty()) {
                return false;
            }
            boolean patternMatched = false;
            Iterator<Pattern> pIterator = this.patternSet.iterator();
            while (pIterator.hasNext() && !patternMatched) {
                patternMatched = this.matchesOnePattern(URL2, pIterator.next());
            }
            return patternMatched;
        }

        private boolean matchesOnePattern(String URL2, Pattern pattern) {
            try {
                boolean matched = false;
                Matcher m = pattern.matcher(URL2);
                matched = m.matches();
                return matched;
            }
            catch (Throwable t) {
                log.error("Failed to match pattern \"" + pattern + "\" against URL " + URL2);
                return false;
            }
        }
    }

    private static class NullFilter
    implements URLFilter {
        private NullFilter() {
        }

        @Override
        public boolean matches(String URL2) {
            return false;
        }
    }
}

