/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util;

import it.jrc.osint.util.WorkspaceFileEditorModel;
import it.jrc.osint.util.io.IOUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class WorkspaceFileEditorModelImpl
implements WorkspaceFileEditorModel,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_DIRTY = "dirty";
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected boolean dirty;
    private String checkPointStateStr;

    protected abstract Serializable getPersistenceObject();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void afterSave() {
    }

    @Override
    public void checkpoint() {
        this.checkPointStateStr = IOUtil.serialize(this.getPersistenceObject());
        if (this.dirty) {
            this.dirty = false;
            this.propertyChangeSupport.firePropertyChange(PROP_DIRTY, true, false);
        }
    }

    protected void prepareChangedModelCheck() {
    }

    protected boolean hasModelChanged() {
        this.prepareChangedModelCheck();
        if (this.getPersistenceObject() == null) {
            return this.checkPointStateStr != null;
        }
        String currentStateStr = IOUtil.serialize(this.getPersistenceObject());
        if (this.checkPointStateStr == null) {
            return true;
        }
        return !this.checkPointStateStr.equals(currentStateStr);
    }

    protected void modelChanged() {
        boolean modelChanged = this.hasModelChanged();
        if (this.dirty != modelChanged) {
            this.dirty = modelChanged;
            this.propertyChangeSupport.firePropertyChange(PROP_DIRTY, !modelChanged, modelChanged);
        }
    }
}

