/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.config;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.config.PropertyProvider;

public class SystemPropertyProvider
implements PropertyProvider {
    private static final Logger log = LogManager.getLogger((String)SystemPropertyProvider.class.getName());
    private String prefix;

    public SystemPropertyProvider(String keyPrefix) {
        this.prefix = keyPrefix;
    }

    public SystemPropertyProvider() {
        this.prefix = "";
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (System.getProperties().contains(String.valueOf(this.prefix) + key)) {
            String result = System.getProperty(String.valueOf(this.prefix) + key);
            log.debug("Obtained property (" + key + "," + result + ")");
            return result;
        }
        log.debug("Property not found, returning default (" + key + "," + defaultValue + ")");
        return defaultValue;
    }
}

