/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.io;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileReaderUtil {
    private static final Logger log = LogManager.getLogger((String)FileReaderUtil.class.getName());
    private String charset = "utf-8";
    private Pattern lineExcludePattern = Pattern.compile("^#(.*)");

    public String read(InputStream in, String charset) {
        String result;
        block5: {
            result = null;
            InputStreamReader inReader = null;
            try {
                try {
                    inReader = new InputStreamReader(in, charset);
                    result = this.read(inReader);
                }
                catch (Throwable t) {
                    log.error("Failed to read string from input stream", t);
                    FileUtil.close(inReader);
                    FileUtil.close(in);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(inReader);
                FileUtil.close(in);
                throw throwable;
            }
            FileUtil.close(inReader);
            FileUtil.close(in);
        }
        return result;
    }

    public String read(InputStreamReader in) {
        String result;
        block6: {
            result = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    int ch;
                    bufferedReader = new BufferedReader(in);
                    StringWriter outWriter = new StringWriter();
                    while ((ch = bufferedReader.read()) != -1) {
                        outWriter.write(ch);
                    }
                    outWriter.flush();
                    result = outWriter.toString();
                }
                catch (Throwable t) {
                    log.error("Failed to read string from input reader", t);
                    FileUtil.close(bufferedReader);
                    FileUtil.close(in);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(bufferedReader);
                FileUtil.close(in);
                throw throwable;
            }
            FileUtil.close(bufferedReader);
            FileUtil.close(in);
        }
        return result;
    }

    public List<String> readLines(InputStream in) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            try {
                in = new BufferedInputStream(in);
                InputStreamReader inReader = new InputStreamReader(in, this.charset);
                BufferedReader bufferedReader = new BufferedReader(inReader);
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (this.filterOut(line)) continue;
                    result.add(line);
                }
                bufferedReader.close();
            }
            catch (Throwable t) {
                log.error("Failed to read line separated strings from input stream", t);
                FileUtil.close(in);
            }
        }
        finally {
            FileUtil.close(in);
        }
        return result;
    }

    private boolean filterOut(String line) {
        if (this.lineExcludePattern == null) {
            return false;
        }
        try {
            Matcher matcher = this.lineExcludePattern.matcher(line);
            if (matcher.matches()) {
                return true;
            }
        }
        catch (Throwable t) {
            log.error("Failed to match input line against exclude pattern ", t);
        }
        return false;
    }

    public void setLineExcludePattern(String pattern) {
        this.lineExcludePattern = Pattern.compile(pattern);
    }

    public void setEncodingCharset(String charset) {
        this.charset = charset;
    }
}

