/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.io;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.io.CharsetUtil;
import it.jrc.osint.util.io.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class FileUtil {
    private static final Logger log = LogManager.getLogger((String)FileUtil.class.getName());

    public static String createValidFilename(String filename) {
        StringBuilder sb = new StringBuilder();
        char[] chars = filename.toCharArray();
        int i = 0;
        while (i < chars.length) {
            sb.append(FileUtil.replaceReservedChar(chars[i]));
            ++i;
        }
        String validName = sb.toString();
        if ((validName = validName.replaceAll("\\s+", " ")).length() >= 255) {
            String fileExtension = FileUtil.getFileExtension(validName);
            if ("".equals(fileExtension)) {
                validName = validName.substring(0, 247);
            } else {
                validName = validName.substring(0, 247);
                validName = String.valueOf(validName) + "." + fileExtension;
            }
        }
        return validName;
    }

    private static char replaceReservedChar(char input) {
        switch (input) {
            case '/': {
                return ' ';
            }
            case '\\': {
                return ' ';
            }
            case '|': {
                return ' ';
            }
            case '?': {
                return ' ';
            }
            case '<': {
                return ' ';
            }
            case '>': {
                return ' ';
            }
            case ':': {
                return ' ';
            }
            case '*': {
                return ' ';
            }
            case '\"': {
                return ' ';
            }
            case '\u0000': {
                return ' ';
            }
        }
        return input;
    }

    public static String createFilenameFromURL(String url) {
        StringBuilder sb = new StringBuilder();
        String raw = null;
        String urlLowerCase = url.toLowerCase();
        raw = urlLowerCase.startsWith("http://") ? url.substring(7) : (urlLowerCase.startsWith("https://") ? url.substring(8) : url);
        char[] chars = raw.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
            } else if (sb.length() == 0) {
                sb.append("_");
            } else {
                sb.append(".");
            }
            ++i;
        }
        i = sb.length() - 1;
        while (sb.charAt(i) == '.') {
            --i;
        }
        return sb.substring(0, i + 1);
    }

    public static boolean hasSuffix(String fileName, String suffices) {
        String[] allowedSuffices;
        if (fileName == null || "".equals(fileName)) {
            return false;
        }
        if (suffices == null || "".equals(suffices)) {
            return false;
        }
        if (!suffices.contains(",")) {
            return fileName.endsWith(suffices);
        }
        String[] stringArray = allowedSuffices = suffices.split(",");
        int n = allowedSuffices.length;
        int n2 = 0;
        while (n2 < n) {
            String aSuffix = stringArray[n2];
            if (fileName.endsWith(aSuffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getFileExtension(String fileName) {
        int suffixSeparatorIndex = fileName.lastIndexOf(".");
        if (suffixSeparatorIndex > 0 && suffixSeparatorIndex < fileName.length()) {
            return fileName.substring(suffixSeparatorIndex + 1);
        }
        return "";
    }

    public static String getPrefix(String fileName) {
        int suffixSeparatorIndex = fileName.lastIndexOf(".");
        if (suffixSeparatorIndex > 0 && suffixSeparatorIndex < fileName.length()) {
            return fileName.substring(0, suffixSeparatorIndex);
        }
        return "";
    }

    public static boolean exists(String path) {
        boolean result = false;
        File fileOrDir = new File(path);
        result = fileOrDir.exists();
        return result;
    }

    public static boolean exists(String dirPath, String fileName) {
        return FileUtil.exists(String.valueOf(dirPath) + File.separator + fileName);
    }

    public static String getNextAvailableName(File parentFolder, String fileName) {
        return FileUtil.getNextAvailableName(parentFolder, fileName, 0);
    }

    private static String getNextAvailableName(File parentFolder, String fileName, int uniqueId) {
        if (parentFolder == null || !parentFolder.exists()) {
            return fileName;
        }
        String testFileName = fileName;
        if (uniqueId > 0) {
            testFileName = String.valueOf(FileUtil.getPrefix(fileName)) + "_" + Integer.toString(uniqueId) + "." + FileUtil.getFileExtension(fileName);
        }
        if (FileUtil.exists(parentFolder.getPath(), testFileName)) {
            return FileUtil.getNextAvailableName(parentFolder, fileName, ++uniqueId);
        }
        return testFileName;
    }

    public static boolean delete(String fileOrDirPath) {
        if (fileOrDirPath == null || "".equals(fileOrDirPath)) {
            return false;
        }
        File dirOrFile = new File(fileOrDirPath);
        if (!dirOrFile.exists()) {
            return false;
        }
        if (dirOrFile.isDirectory()) {
            FileUtil.deleteChildsOfDirectory(fileOrDirPath);
            return FileUtil.deleteFile(fileOrDirPath);
        }
        return FileUtil.deleteFile(fileOrDirPath);
    }

    private static void deleteChildsOfDirectory(String dirPath) {
        File[] childs;
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return;
        }
        File[] fileArray = childs = dir.listFiles();
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                FileUtil.deleteChildsOfDirectory(child.getPath());
                child.delete();
            } else {
                child.delete();
            }
            ++n2;
        }
    }

    private static boolean deleteFile(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return false;
        }
        try {
            File f = new File(filePath);
            if (f.exists()) {
                return f.delete();
            }
            return false;
        }
        catch (Exception e) {
            log.error("Failed to delete file " + filePath, (Throwable)e);
            return false;
        }
    }

    public static boolean setReadOnly(String filePath) {
        File aFile = new File(filePath);
        if (aFile.exists()) {
            return aFile.setReadOnly();
        }
        return false;
    }

    public static boolean writeFile(String filePath, String content) {
        FileOutputStream fileOut = null;
        OutputStreamWriter streamWriter = null;
        try {
            fileOut = new FileOutputStream(filePath);
            streamWriter = new OutputStreamWriter((OutputStream)fileOut, Charset.defaultCharset());
            streamWriter.write(content);
            streamWriter.flush();
            return true;
        }
        catch (IOException e) {
            log.error("Failed to write file " + filePath, (Throwable)e);
        }
        finally {
            try {
                if (streamWriter != null) {
                    streamWriter.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to close output stream properly", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean writeUTF8File(String filePath, String content) {
        FileOutputStream fileOut = null;
        OutputStreamWriter streamWriter = null;
        try {
            fileOut = new FileOutputStream(filePath);
            streamWriter = new OutputStreamWriter((OutputStream)fileOut, "utf-8");
            streamWriter.write(content);
            streamWriter.flush();
            return true;
        }
        catch (IOException e) {
            log.error("Failed to write file " + filePath, (Throwable)e);
        }
        finally {
            try {
                if (streamWriter != null) {
                    streamWriter.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to close output stream properly", (Throwable)e);
            }
        }
        return false;
    }

    public static String readFile(String filePath) {
        File inFile = new File(filePath);
        if (!inFile.exists()) {
            return null;
        }
        Charset charset = Charset.defaultCharset();
        try {
            charset = CharsetUtil.guessEncoding(inFile, 4096);
        }
        catch (Exception e) {
            log.error("Failed to guess charset of file:" + filePath, (Throwable)e);
            charset = Charset.defaultCharset();
        }
        return FileUtil.readFile(filePath, charset.name());
    }

    public static String readUTF8File(String filePath) {
        return FileUtil.readFile(filePath, "utf-8");
    }

    public static String readFile(InputStream in, String charset) {
        String string;
        BufferedInputStream bin = null;
        try {
            int ch;
            bin = new BufferedInputStream(in);
            InputStreamReader inReader = new InputStreamReader((InputStream)bin, charset);
            StringWriter outWriter = new StringWriter();
            while ((ch = inReader.read()) != -1) {
                outWriter.write(ch);
            }
            outWriter.flush();
            string = outWriter.toString();
        }
        catch (Exception e) {
            try {
                log.error("Read of text from input stream failed", (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtil.close(bin);
                FileUtil.close(in);
                throw throwable;
            }
            FileUtil.close(bin);
            FileUtil.close(in);
            return null;
        }
        FileUtil.close(bin);
        FileUtil.close(in);
        return string;
    }

    public static String readFile(String filePath, String charset) {
        try {
            FileInputStream in = new FileInputStream(filePath);
            return FileUtil.readFile(in, charset);
        }
        catch (Throwable t) {
            log.error("Failed to read file from path " + filePath);
            return null;
        }
    }

    public static InputStream getResourceAsStream(String fileName, ClassLoader classLoader) {
        log.debug("[getResourceAsStream] Loading resource from " + fileName);
        File inputFile = new File(fileName);
        if (inputFile.exists()) {
            log.debug("[getResourceAsStream] loading from file ");
            try {
                FileInputStream fileIn = new FileInputStream(inputFile);
                return fileIn;
            }
            catch (FileNotFoundException e) {
                log.error("Could not open file resource for input", (Throwable)e);
                return null;
            }
        }
        log.debug("[getResourceAsStream] loading from ClassLoader ");
        InputStream clIn = classLoader.getResourceAsStream(fileName);
        return clIn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void touch(String dirPath, String fileName) {
        File signalFile = new File(String.valueOf(dirPath) + File.separator + fileName);
        FileOutputStream fileOut = null;
        try {
            try {
                fileOut = new FileOutputStream(signalFile);
                fileOut.write(0);
                fileOut.flush();
                return;
            }
            catch (FileNotFoundException e) {
                log.error("Could not create signal file: " + signalFile.getPath(), (Throwable)e);
                if (fileOut == null) return;
                try {
                    fileOut.close();
                    return;
                }
                catch (Exception e2) {
                    log.error("Could not close file output stream properly", (Throwable)e2);
                }
                return;
            }
            catch (IOException e) {
                log.error("Could not write null byte to signal file", (Throwable)e);
                if (fileOut == null) return;
                try {
                    fileOut.close();
                    return;
                }
                catch (Exception e3) {
                    log.error("Could not close file output stream properly", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (Exception e) {
                    log.error("Could not close file output stream properly", (Throwable)e);
                }
            }
        }
    }

    public static boolean mkdirs(String baseDirPath, String[] subDirPaths) {
        File baseDir = new File(baseDirPath);
        if (!baseDir.exists()) {
            return false;
        }
        if (subDirPaths == null || subDirPaths.length == 0) {
            return false;
        }
        String[] stringArray = subDirPaths;
        int n = subDirPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String aSubDirPath = stringArray[n2];
            String newSubDirPath = String.valueOf(baseDirPath) + File.separator + aSubDirPath;
            File subDir = new File(newSubDirPath);
            subDir.mkdir();
            if (!FileUtil.exists(newSubDirPath)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean copy(String sourcePath, String targetPath) {
        return FileUtil.copy(new File(sourcePath), new File(targetPath));
    }

    public static boolean copy(String sourcePath, String targetPath, boolean recursive) {
        return FileUtil.copy(new File(sourcePath), new File(targetPath), recursive);
    }

    public static boolean copy(File sourceFile, File targetFile) {
        return FileUtil.copy(sourceFile, targetFile, true);
    }

    public static boolean copy(File sourceFile, File targetFile, boolean recursive) {
        if (!sourceFile.exists()) {
            log.error("Source " + sourceFile.getPath() + " does not exist");
            return false;
        }
        if (sourceFile.isFile()) {
            return FileUtil.copyFile(sourceFile, targetFile);
        }
        return FileUtil.copyDir(sourceFile, targetFile, recursive);
    }

    private static boolean copyFile(File sourceFile, File targetFile) {
        if (targetFile.isDirectory()) {
            String targetFilePath = String.valueOf(targetFile.getPath()) + File.separator + sourceFile.getName();
            return FileUtil.copyFile2File(sourceFile.getPath(), targetFilePath);
        }
        return FileUtil.copyFile2File(sourceFile.getPath(), targetFile.getPath());
    }

    private static boolean copyDir(File sourceFile, File targetFile, boolean recursive) {
        File[] children;
        if (targetFile.exists()) {
            if (targetFile.isFile()) {
                log.error("Could not copy dir " + sourceFile.getPath() + " to target file " + targetFile.getPath());
                return false;
            }
        } else {
            boolean createTarget = targetFile.mkdirs();
            if (!createTarget) {
                log.error("Could not create target dir " + targetFile.getPath());
                return false;
            }
        }
        if ((children = sourceFile.listFiles()) == null) {
            return true;
        }
        boolean childOperationResult = true;
        int i = 0;
        while (i < children.length) {
            boolean result;
            if (!childOperationResult) break;
            if (recursive) {
                if (children[i].isDirectory()) {
                    String targetSubDirPath = String.valueOf(targetFile.getPath()) + File.separator + children[i].getName();
                    File targetSubDir = new File(targetSubDirPath);
                    boolean createSubDirResult = targetSubDir.mkdirs();
                    if (!createSubDirResult) {
                        childOperationResult = false;
                        break;
                    }
                    boolean result2 = FileUtil.copy(children[i], targetSubDir, true);
                    if (!result2) {
                        childOperationResult = false;
                        break;
                    }
                } else {
                    boolean result3 = FileUtil.copy(children[i], targetFile);
                    if (!result3) {
                        childOperationResult = false;
                        break;
                    }
                }
            } else if (children[i].isFile() && !(result = FileUtil.copy(children[i], targetFile))) {
                childOperationResult = false;
                break;
            }
            ++i;
        }
        return childOperationResult;
    }

    public static boolean move(String sourcePath, String targetPath) {
        File sourceFile = new File(sourcePath);
        File targetFile = new File(targetPath);
        if (!sourceFile.exists()) {
            return false;
        }
        return FileUtil.move(sourceFile, targetFile);
    }

    private static boolean move(File sourceFile, File targetFile) {
        if (sourceFile.isFile()) {
            if (targetFile.isFile()) {
                return FileUtil.moveFile2File(sourceFile, targetFile);
            }
            return FileUtil.moveFile2Dir(sourceFile, targetFile);
        }
        if (targetFile.isFile()) {
            return false;
        }
        return FileUtil.moveDir2Dir(sourceFile, targetFile);
    }

    private static boolean moveFile2Dir(File sourceFile, File targetDir) {
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            return false;
        }
        String targetFilePath = targetDir + File.separator + sourceFile.getName();
        File targetFile = new File(targetFilePath);
        return FileUtil.moveFile2File(sourceFile, targetFile);
    }

    private static boolean moveDir2Dir(File sourceDir, File targetDir) {
        boolean result = true;
        if (targetDir.exists()) {
            File[] children;
            File[] fileArray = children = sourceDir.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File aChild = fileArray[n2];
                String targetFilePath = String.valueOf(targetDir.getPath()) + File.separator + aChild.getName();
                File targetFile = new File(targetFilePath);
                result = FileUtil.move(aChild, targetFile);
                if (!result) {
                    return false;
                }
                ++n2;
            }
            result = sourceDir.delete();
        } else {
            result = sourceDir.renameTo(targetDir);
        }
        return result;
    }

    private static boolean moveFile2File(File sourceFile, File targetFile) {
        boolean result = true;
        if (targetFile.exists() && !(result = targetFile.delete())) {
            return false;
        }
        result = sourceFile.renameTo(targetFile);
        return result;
    }

    private static boolean copyFile2File(String sourceFilePath, String targetFilePath) {
        try {
            int ch;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceFilePath));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFilePath));
            while ((ch = in.read()) != -1) {
                out.write(ch);
            }
            in.close();
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e) {
            log.error("Copy of file " + sourceFilePath + " to " + targetFilePath + " failed.", (Throwable)e);
            return false;
        }
    }

    public static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                IOUtil.log.error("Failed to close input stream properly", (Throwable)e);
            }
        }
    }

    public static void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                IOUtil.log.error("Failed to close reader properly", (Throwable)e);
            }
        }
    }

    public static void close(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                IOUtil.log.error("Failed to close writer properly", (Throwable)e);
            }
        }
    }

    public static void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                IOUtil.log.error("Failed to close output stream properly", (Throwable)e);
            }
        }
    }
}

