/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.test;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class TestUtil {
    private static final Logger log = LogManager.getLogger((String)TestUtil.class.getName());

    public static void setupLogging() {
    }

    public static void tearDownLogging() {
    }

    public static String getTestBaseDir() {
        String testDirPath = System.getProperty("test.base");
        if (testDirPath != null) {
            return testDirPath;
        }
        String testDirName = String.valueOf(System.getProperty("user.dir")) + File.separator + "test";
        File testDirFile = new File(testDirName);
        if (!testDirFile.exists()) {
            throw new IllegalStateException("test.prepare to create test working dir");
        }
        return testDirName;
    }

    public static String getTestBaseDir(String subDir) {
        return String.valueOf(TestUtil.getTestBaseDir()) + File.separator + subDir;
    }

    public static void dumpToFile(String fileName, String content) {
        block12: {
            OutputStreamWriter writer = null;
            try {
                try {
                    FileOutputStream dump = new FileOutputStream(fileName);
                    writer = new OutputStreamWriter((OutputStream)dump, "utf-8");
                    writer.write(content);
                }
                catch (Exception e) {
                    log.error("Debug code yielded exception", (Throwable)e);
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        log.error("Could not close OutputStreamWriter for " + fileName + " properly", (Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        log.error("Could not close OutputStreamWriter for " + fileName + " properly", (Throwable)e);
                    }
                }
            }
        }
    }
}

