/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.text;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLUtil {
    private static final Logger log = LogManager.getLogger((String)HTMLUtil.class.getName());

    public static String encodeHTMLSpecialChars(String text) {
        String result = text.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        return result;
    }

    public static String replaceLineFeedWithBR(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(16384);
        char[] cbuf = new char[1024];
        try {
            int read;
            StringReader sr = new StringReader(text);
            while ((read = sr.read(cbuf, 0, 1024)) != -1) {
                int i = 0;
                while (i < read) {
                    if (cbuf[i] == '\n') {
                        sb.append("<br/>");
                    }
                    sb.append(cbuf[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            log.error("Replacing of line feeds with BR tag failed", (Throwable)e);
        }
        return sb.toString();
    }

    public static Pattern getHighlightPattern(String regEx) {
        return Pattern.compile(regEx);
    }

    public static String highlightPatternWithSpan(Pattern regExPattern, String html, String colour) {
        if (regExPattern == null) {
            return html;
        }
        if (html == null || "".equals(html)) {
            return html;
        }
        String result = null;
        try {
            Matcher m = regExPattern.matcher(html);
            StringBuffer sb = new StringBuffer(16384);
            while (m.find()) {
                int g = 1;
                while (g < m.groupCount() + 1) {
                    String found = m.group(g);
                    if (found != null) {
                        m.appendReplacement(sb, "<span style=\"background-color:" + colour + ";border:solid black 1\">" + found + "</span>");
                    }
                    ++g;
                }
            }
            m.appendTail(sb);
            result = sb.toString();
        }
        catch (Exception e) {
            log.error("Highlighting of regular expression failed", (Throwable)e);
        }
        return result;
    }

    public static String highlightPatternWithSpan(String regEx, String html, String colour) {
        if (regEx == null || "".equals(regEx)) {
            return html;
        }
        Pattern regExPattern = HTMLUtil.getHighlightPattern(regEx);
        return HTMLUtil.highlightPatternWithSpan(regExPattern, html, colour);
    }

    public static String stripTags(String htmlText) {
        String noHTMLString = htmlText.replaceAll("\\<.*?\\>", "");
        return noHTMLString;
    }
}

