/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.util.text;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class RegexUtil {
    private static final Logger log = LogManager.getLogger((String)RegexUtil.class.getName());

    public static String getPatternForBasicQuery(String bqWithAllRegex, String bqExactRegex, String bqAtLeastRegex) {
        String withAllRegex = RegexUtil.getPatternForSearchTerm(bqWithAllRegex);
        String exactRegex = RegexUtil.getPatternForExactPhrase(bqExactRegex);
        String atLeastRegex = RegexUtil.getPatternForSearchTerm(bqAtLeastRegex);
        StringBuffer searchRegexStrBuf = new StringBuffer();
        searchRegexStrBuf.append(withAllRegex);
        if (exactRegex.length() > 0) {
            if (searchRegexStrBuf.length() > 0) {
                searchRegexStrBuf.append('|');
            }
            searchRegexStrBuf.append(exactRegex);
        }
        if (atLeastRegex.length() > 0) {
            if (searchRegexStrBuf.length() > 0) {
                searchRegexStrBuf.append('|');
            }
            searchRegexStrBuf.append(atLeastRegex);
        }
        String result = searchRegexStrBuf.toString();
        return result;
    }

    public static String getPatternForSearchTerm(String searchTerm) {
        String regex;
        if (searchTerm == null || "".equals(searchTerm.trim())) {
            return "";
        }
        StringBuffer regexStrBuf = new StringBuffer();
        int nGroup = 0;
        if (searchTerm != null && !"".equals(searchTerm)) {
            StringTokenizer st = new StringTokenizer(searchTerm, " ");
            while (st.hasMoreTokens()) {
                String termWord = st.nextToken();
                if (nGroup > 0) {
                    regexStrBuf.append("|");
                }
                regexStrBuf.append("(");
                regexStrBuf.append("\\b" + Pattern.quote(termWord));
                regexStrBuf.append("\\b");
                regexStrBuf.append(")");
                ++nGroup;
            }
        }
        if ((regex = regexStrBuf.toString()) == null) {
            return "";
        }
        return regex;
    }

    public static String getPatternForListOfAliases(List<String> aliases) {
        StringBuffer regexStrBuf = new StringBuffer("");
        int nGroup = 0;
        for (String alias : aliases) {
            if (nGroup > 0) {
                regexStrBuf.append("|");
            }
            regexStrBuf.append(RegexUtil.getPatternForExactPhrase(alias));
            ++nGroup;
        }
        return regexStrBuf.toString();
    }

    public static String getPatternForExactPhrase(String entityName) {
        if (entityName == null || "".equals(entityName.trim())) {
            return "";
        }
        StringBuffer regexStrBuf = new StringBuffer("");
        regexStrBuf.append("(");
        regexStrBuf.append("\\b");
        regexStrBuf.append(Pattern.quote(entityName));
        regexStrBuf.append("\\b");
        regexStrBuf.append(")");
        return regexStrBuf.toString();
    }

    public static Pattern compilePattern(String aPattern) {
        if (aPattern == null) {
            return null;
        }
        if ("".equals(aPattern = aPattern.trim())) {
            return null;
        }
        try {
            Pattern compiledPattern = Pattern.compile(aPattern);
            return compiledPattern;
        }
        catch (Throwable t) {
            log.error("Failed to compile regex pattern " + aPattern + " - will be ignored", t);
            return null;
        }
    }

    public static String buildExcludeDomainsPattern(String[] excludedDomains) {
        StringBuilder excludeDomainsPattern = new StringBuilder("^http://(");
        int i = 0;
        while (i < excludedDomains.length) {
            if (i > 0 && i + 1 <= excludedDomains.length) {
                excludeDomainsPattern.append("|(");
            } else {
                excludeDomainsPattern.append("(");
            }
            excludeDomainsPattern.append(RegexUtil.escape4Regex(excludedDomains[i]));
            excludeDomainsPattern.append(")+");
            ++i;
        }
        excludeDomainsPattern.append(")");
        return excludeDomainsPattern.toString();
    }

    public static String escape4Regex(String domain) {
        String result = domain.replace(".", "\\.");
        return result;
    }
}

