/*
 * Decompiled with CFR 0.152.
 */
package test.util.concurrent;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.AbstractProducer;
import it.jrc.osint.util.concurrent.ParallelProcessor2;
import it.jrc.osint.util.concurrent.ProcessingException;
import it.jrc.osint.util.concurrent.ProcessorParameters;
import it.jrc.osint.util.test.TestUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.util.concurrent.StringConcatTask;

public class TestParallelProcessor2 {
    private static final Logger log = LogManager.getLogger((String)TestParallelProcessor2.class.getName());

    @Before
    public void setup() {
        TestUtil.setupLogging();
    }

    @Test
    public void processStringsSerial() throws ProcessingException {
        StringProducer stringProducer = new StringProducer();
        ParallelProcessor2<String> stringProcessor = new ParallelProcessor2<String>(stringProducer, new StringConcatTask());
        stringProcessor.setThreadPoolSize(1);
        Iterator<String> resultIterator = stringProcessor.start(null);
        while (resultIterator.hasNext()) {
            String nextResult = resultIterator.next();
            log.debug("Next Result: " + nextResult);
        }
        log.debug("Processing finished");
    }

    @Test
    public void processStringParallel() throws ProcessingException, InterruptedException, ExecutionException {
        ParallelProcessor2<String> stringProcessor = new ParallelProcessor2<String>(new StringProducer(100), new StringConcatTask());
        Iterator<String> resultIterator = stringProcessor.start(null);
        LinkedList<String> resultList = new LinkedList<String>();
        while (resultIterator.hasNext()) {
            String nextItem = resultIterator.next();
            if (nextItem != null) {
                resultList.add(nextItem);
                continue;
            }
            log.error("Result item is null");
        }
        log.debug("Result list has " + resultList.size() + " items");
        Assert.assertEquals((String)"Consumer did not receive all processed items", (long)100L, (long)resultList.size());
    }

    @Test
    public void cancelProcessingImmediately() throws ProcessingException {
        StringProducer stringProducer = new StringProducer(100);
        ProcessorParameters processorParams = new ProcessorParameters();
        processorParams.setConsumerQueueCapacity(10);
        processorParams.setProducerQueueCapacity(10);
        processorParams.setThreadPoolSize(1);
        ParallelProcessor2<String> stringProcessor = new ParallelProcessor2<String>(stringProducer, new StringConcatTask());
        stringProcessor.setParameters(processorParams);
        LinkedList<String> resultList = new LinkedList<String>();
        Iterator<String> resultIterator = stringProcessor.start(null);
        while (resultIterator.hasNext()) {
            String nextItem = resultIterator.next();
            stringProcessor.cancel();
            if (nextItem != null) {
                resultList.add(nextItem);
                continue;
            }
            log.error("Result item is null");
        }
        Assert.assertTrue((String)"Cancel failed, all items were processed", (resultList.size() < 100 ? 1 : 0) != 0);
    }

    private static class StringProducer
    extends AbstractProducer<String> {
        private int itemsToProduce;
        private int i;

        public StringProducer() {
            this(100);
        }

        public StringProducer(int itemsToProduce) {
            this.itemsToProduce = itemsToProduce;
            this.i = 0;
        }

        @Override
        public int expectedItemCount() {
            return this.itemsToProduce;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.itemsToProduce;
        }

        @Override
        public String next() {
            String numberStr = "" + this.i++;
            return numberStr;
        }

        @Override
        public Iterator<String> iterator() {
            try {
                this.setContext(null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return this;
        }

        @Override
        public void reset() {
            this.i = 0;
        }
    }
}

