/*
 * Decompiled with CFR 0.152.
 */
package test.util.concurrent;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.concurrent.AbstractProcessingTask;
import it.jrc.osint.util.concurrent.AbstractProducer;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.PipelineProcessor;
import it.jrc.osint.util.concurrent.ProcessingContext;
import it.jrc.osint.util.concurrent.ProcessingException;
import it.jrc.osint.util.test.TestUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.util.concurrent.ListConsumer;

public class TestPipelineProcessor {
    private static final Logger log = LogManager.getLogger((String)TestPipelineProcessor.class.getName());

    @Before
    public void setup() {
        TestUtil.setupLogging();
    }

    @Test
    public void processStringsPipelined() throws ProcessingException {
        StringProducer stringProducer = new StringProducer();
        ListConsumer stringConsumer = new ListConsumer();
        ArrayList tasks = new ArrayList();
        tasks.add(new TestTask1());
        tasks.add(new TestTask2());
        PipelineProcessor<String> processor = new PipelineProcessor<String>(stringProducer, stringConsumer, tasks);
        Future<Consumer<String>> processorFuture = processor.start(null);
        try {
            processorFuture.get();
        }
        catch (Exception e) {
            Assert.fail((String)"Processing was aborted");
        }
        for (String str : stringConsumer.getList()) {
            log.debug(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelProcessorFuture() throws ProcessingException {
        StringProducer stringProducer = new StringProducer(10);
        ListConsumer stringConsumer = new ListConsumer();
        ArrayList tasks = new ArrayList();
        tasks.add(new TestTask1());
        tasks.add(new TestTask2());
        PipelineProcessor<String> processor = new PipelineProcessor<String>(stringProducer, stringConsumer, tasks);
        Future<Consumer<String>> processorFuture = processor.start(null);
        TestPipelineProcessor testPipelineProcessor = this;
        synchronized (testPipelineProcessor) {
            try {
                this.wait(3000L);
                processorFuture.cancel(true);
                this.wait(10000L);
                Assert.assertTrue((String)"Cancel failed, all items were processed", (stringConsumer.consumedItemCount() < 100 ? 1 : 0) != 0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (String str : stringConsumer.getList()) {
            log.debug(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cancelProgressMonitor() throws ProcessingException {
        StringProducer stringProducer = new StringProducer(10);
        ListConsumer stringConsumer = new ListConsumer();
        ArrayList tasks = new ArrayList();
        tasks.add(new TestTask1());
        tasks.add(new TestTask2());
        PipelineProcessor<String> processor = new PipelineProcessor<String>(stringProducer, stringConsumer, tasks);
        processor.setProducerQueueCapacity(1);
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        Future<Consumer<String>> processorFuture = processor.start((IProgressMonitor)progressMonitor);
        TestPipelineProcessor testPipelineProcessor = this;
        synchronized (testPipelineProcessor) {
            try {
                this.wait(3000L);
                progressMonitor.setCanceled(true);
                this.wait(10000L);
                Assert.assertTrue((String)"Cancel failed, all items were processed", (stringConsumer.consumedItemCount() < 100 ? 1 : 0) != 0);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            processorFuture.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        for (String str : stringConsumer.getList()) {
            log.debug(str);
        }
    }

    @Test
    public void shortPipeline() throws ProcessingException {
        StringProducer stringProducer = new StringProducer(2);
        ListConsumer stringConsumer = new ListConsumer();
        ArrayList tasks = new ArrayList();
        tasks.add(new TestTask2());
        PipelineProcessor<String> processor = new PipelineProcessor<String>(stringProducer, stringConsumer, tasks);
        Future<Consumer<String>> processorFuture = processor.start(null);
        try {
            processorFuture.get();
        }
        catch (ExecutionException e) {
            log.error("Failure", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Failure", (Throwable)e);
        }
        for (String str : stringConsumer.getList()) {
            log.debug(str);
        }
    }

    private static class StringProducer
    extends AbstractProducer<String> {
        private int itemsToProduce;
        private int i;

        public StringProducer() {
            this(100);
        }

        public StringProducer(int itemsToProduce) {
            this.itemsToProduce = itemsToProduce;
        }

        @Override
        public int expectedItemCount() {
            return this.itemsToProduce;
        }

        @Override
        public void setContext(ProcessingContext context) {
            super.setContext(context);
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.itemsToProduce;
        }

        @Override
        public String next() {
            String numberStr = "" + this.i++;
            return numberStr;
        }

        @Override
        public Iterator<String> iterator() {
            try {
                this.setContext(null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return this;
        }
    }

    private static class TestTask1
    extends AbstractProcessingTask<String> {
        private TestTask1() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String process(String inputItem) throws ProcessingException {
            String outputItem;
            String string = outputItem = String.valueOf(inputItem) + "+1";
            synchronized (string) {
                try {
                    outputItem.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return outputItem;
        }
    }

    private static class TestTask2
    extends AbstractProcessingTask<String> {
        private TestTask2() {
        }

        @Override
        public String process(String inputItem) throws ProcessingException {
            String outputItem = String.valueOf(inputItem) + "+2";
            return outputItem;
        }
    }
}

