/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui;

import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.ui.browser.OSINTWebBrowserEditor;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class SearchServiceSourceProvider
extends AbstractSourceProvider {
    public static final String CAN_EXTRACT_CURRENT_URL = "it.jrc.osint.ui.canExtractCurrentURL";
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();

    private SearchService getSearchService() {
        return SearchUIPlugin.getSearchService();
    }

    public void initialize(IServiceLocator locator) {
        super.initialize(locator);
        SearchUIPlugin.getPlugin().getEventBroker().register(new String[]{"osint/search/urlChanged"}, this.topicEventListener);
    }

    public void dispose() {
        SearchUIPlugin.getPlugin().getEventBroker().unregister(this.topicEventListener);
    }

    private boolean canExtract() {
        IWorkbenchPage wbPage;
        block8: {
            IWorkbenchWindow wbWindow;
            block7: {
                IWorkbench wb;
                block6: {
                    wb = PlatformUI.getWorkbench();
                    if (wb != null) break block6;
                    return false;
                }
                wbWindow = wb.getActiveWorkbenchWindow();
                if (wbWindow != null) break block7;
                return false;
            }
            wbPage = wbWindow.getActivePage();
            if (wbPage != null) break block8;
            return false;
        }
        try {
            IEditorPart activeEditor = wbPage.getActiveEditor();
            if (activeEditor instanceof OSINTWebBrowserEditor) {
                OSINTWebBrowserEditor browserEditor = (OSINTWebBrowserEditor)activeEditor;
                String currentURL = browserEditor.getURL();
                return this.getSearchService().canExtractResultLinks(currentURL);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public Map getCurrentState() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put(CAN_EXTRACT_CURRENT_URL, this.canExtract());
        return map;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{CAN_EXTRACT_CURRENT_URL};
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if ("osint/search/urlChanged".equals(event.getTopic())) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean canExtractValue = SearchServiceSourceProvider.this.canExtract();
                        SearchServiceSourceProvider.this.fireSourceChanged(65536, SearchServiceSourceProvider.CAN_EXTRACT_CURRENT_URL, canExtractValue);
                    }
                });
            }
        }
    }
}

