/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.handlers;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.io.FileUtil;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyURLHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)CopyURLHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block5: {
            IFile bookmarkFile;
            block6: {
                TreePath[] paths;
                block4: {
                    try {
                        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
                        ISelection selection = window.getSelectionService().getSelection();
                        TreeSelection treeSelection = (TreeSelection)selection;
                        paths = treeSelection.getPaths();
                        if (paths != null && paths.length >= 1) break block4;
                        log.warn("Selection is null or empty");
                        return null;
                    }
                    catch (Throwable t) {
                        log.error("Failed to start http grabber", t);
                        return null;
                    }
                }
                TreePath aTreePath = paths[0];
                Object lastSegment = aTreePath.getLastSegment();
                if (!(lastSegment instanceof IFile)) break block5;
                bookmarkFile = (IFile)lastSegment;
                if (bookmarkFile.getName().endsWith("obm")) break block6;
                return null;
            }
            String url2copy = this.getURLFromBookmarkFile(bookmarkFile);
            this.copyURL2Clipboard(url2copy);
        }
        return null;
    }

    private String getURLFromBookmarkFile(IFile bookmarkFile) {
        if (bookmarkFile == null || !bookmarkFile.exists()) {
            log.warn("loadURLBookmark: file not existing or null");
            return null;
        }
        InputStream in = null;
        try {
            in = bookmarkFile.getContents();
            URLBookmark bookmark = SearchUIPlugin.getSearchService().loadBookmark(bookmarkFile.getContents());
            String string = bookmark.getURL();
            return string;
        }
        catch (Throwable t) {
            log.error("Failed to load URLBookmark from " + bookmarkFile.getName(), t);
        }
        finally {
            FileUtil.close((InputStream)in);
        }
        return null;
    }

    private void copyURL2Clipboard(String url) {
        try {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            TextTransfer textTransfer = TextTransfer.getInstance();
            URLTransfer urlTransfer = URLTransfer.getInstance();
            clipboard.setContents((Object[])new String[]{url, url}, new Transfer[]{textTransfer, urlTransfer});
            clipboard.dispose();
        }
        catch (Throwable t) {
            log.error("Failed to copy URL to clipboard", t);
        }
    }
}

