/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.handlers;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchPlugin;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.ui.browser.BrowserContainer;
import it.jrc.osint.util.ui.dialog.ProjectSelectionDialog;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.WorkspaceService;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExtractSearchURLsHandler
extends AbstractHandler {
    private static final Logger log = LogManager.getLogger((String)ExtractSearchURLsHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        BrowserContainer searchBrowser = (BrowserContainer)activeEditor.getAdapter(BrowserContainer.class);
        WorkspaceService workspaceService = SearchUIPlugin.getWorkspaceService();
        CaseProject targetProject = null;
        List projects = workspaceService.getCaseProjects();
        if (projects.isEmpty()) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)"Create Case Project", (String)"Please create a case project first");
            return null;
        }
        if (projects.size() == 1) {
            targetProject = (CaseProject)projects.get(0);
        } else {
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), SearchUIPlugin.getPlugin().getImageRegistry().get("folder"));
            dialog.setMessage("Select project to store extracted URLs");
            dialog.setProjects(projects);
            int userSelection = dialog.open();
            if (userSelection == 0) {
                targetProject = dialog.getSelectedProject();
            }
        }
        if (targetProject == null) {
            return null;
        }
        if (searchBrowser != null) {
            String url;
            SearchService searchSvc = SearchPlugin.getSearchService();
            if (searchSvc.canExtractResultLinks(url = searchBrowser.getBrowser().getUrl())) {
                MessageDialogWithToggle dialog;
                boolean toggleState;
                String showDialogPreferenceKey = "it.jrc.osint.ui.handler.ExtractSearchURLsHandler.showBrowserTakeOverInformation";
                if (!SearchUIPlugin.getPlugin().getPreferenceStore().getBoolean(showDialogPreferenceKey) && (toggleState = (dialog = MessageDialogWithToggle.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Automatic Link Extraction", (String)"Your browser window will now be taken over in order to extract the result links from this search. Please wait until browser activity has finished.", (String)"Do not show this information again", (boolean)false, (IPreferenceStore)SearchUIPlugin.getPlugin().getPreferenceStore(), (String)showDialogPreferenceKey)).getToggleState())) {
                    SearchUIPlugin.getPlugin().getPreferenceStore().setValue(showDialogPreferenceKey, true);
                }
                searchSvc.extractResultLinks(searchBrowser.getBrowser().getUrl(), targetProject, searchBrowser.getBrowser());
            }
        } else {
            log.debug("Could not adapt editor to browser");
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
    }

    public boolean isEnabled() {
        return true;
    }
}

