/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.properties;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.search.ui.properties.URLBookmarkPropertySourceProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class URLBookmarkPropertySection
extends AbstractPropertySection {
    private static final Logger log = LogManager.getLogger((String)URLBookmarkPropertySection.class.getName());
    protected PropertySheetPage page;

    public void createControls(Composite parent, final TabbedPropertySheetPage atabbedPropertySheetPage) {
        super.createControls(parent, atabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.page = new PropertySheetPage();
        this.page.createControl(composite);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.page.getControl().setLayoutData((Object)data);
        this.page.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                atabbedPropertySheetPage.resizeScrolledComposite();
            }
        });
        this.page.setPropertySourceProvider((IPropertySourceProvider)new URLBookmarkPropertySourceProvider());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object inputObject;
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (inputObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            URLBookmark bookmark;
            IFile aFile = (IFile)inputObject;
            String contentType = this.getContentType(aFile);
            if (contentType == null) {
                return;
            }
            if ("it.jrc.osint.contenttype.URLBookmark".equals(contentType) && (bookmark = this.loadBookmark(aFile)) != null) {
                super.setInput(part, (ISelection)new StructuredSelection((Object)bookmark));
                this.page.selectionChanged(part, selection);
                return;
            }
        }
    }

    private String getContentType(IFile aFile) {
        try {
            IContentDescription contentDesc = aFile.getContentDescription();
            if (contentDesc != null) {
                IContentType contentType = contentDesc.getContentType();
                return contentType.getId();
            }
        }
        catch (Throwable t) {
            log.error("Failed to retrieve content type for file " + aFile.getFullPath());
        }
        return null;
    }

    private URLBookmark loadBookmark(IFile file) {
        URLBookmark bookmark = null;
        try {
            SearchService ss = SearchUIPlugin.getSearchService();
            bookmark = ss.loadBookmark(file.getContents());
        }
        catch (Throwable t) {
            log.error("Failed to load bookmark from file " + file.getFullPath());
        }
        return bookmark;
    }

    public void dispose() {
        super.dispose();
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }

    public void refresh() {
        this.page.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

