/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.view;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.LinkExtractorDescription;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.util.ui.StructuredContentProviderAdapter;
import it.jrc.osint.util.ui.TableLabelProviderAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class SearchToolsView
extends ViewPart {
    public static final String VIEW_ID = "it.jrc.osint.ui.views.tools";
    private static final Logger log = LogManager.getLogger((String)SearchToolsView.class.getName());
    private TableViewer tableViewer;
    private Map<String, LinkExtractorDescription> extractorDescriptionMap = new HashMap<String, LinkExtractorDescription>();
    private TopicEventListener topicEventListener;

    public void createPartControl(Composite parent) {
        this.tableViewer = new TableViewer(parent, 2048);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    TableViewer tv = (TableViewer)event.getSource();
                    IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    LinkExtractorDescription led = (LinkExtractorDescription)selection.getFirstElement();
                    if (led != null && led.getHomePageURL() != null) {
                        IHandlerService handlerService = (IHandlerService)SearchToolsView.this.getSite().getService(IHandlerService.class);
                        ICommandService commandService = (ICommandService)SearchToolsView.this.getSite().getService(ICommandService.class);
                        Command openBrowser = commandService.getCommand("org.eclipse.ui.browser.openBrowser");
                        IParameter urlParam = openBrowser.getParameter("url");
                        Parameterization parm = new Parameterization(urlParam, led.getHomePageURL());
                        ParameterizedCommand parmCommand = new ParameterizedCommand(openBrowser, new Parameterization[]{parm});
                        handlerService.executeCommand(parmCommand, null);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        this.tableViewer.getTable().setHeaderVisible(false);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.loadTableItems();
        this.initializeToolBar();
    }

    public void setFocus() {
    }

    private void initializeToolBar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
    }

    public void refresh() {
        this.loadTableItems();
    }

    private void loadTableItems() {
        this.extractorDescriptionMap.clear();
        SearchService ss = SearchUIPlugin.getSearchService();
        List leds = ss.getLinkExtractorDescriptions();
        for (LinkExtractorDescription led : leds) {
            this.extractorDescriptionMap.put(led.getName(), led);
            this.tableViewer.setInput(this.extractorDescriptionMap);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.topicEventListener = new TopicEventListenerImpl();
        SearchUIPlugin.getPlugin().getEventBroker().register(new String[]{"osint/search/linkExtractorDefinitionsChanged"}, this.topicEventListener);
    }

    public void dispose() {
        SearchUIPlugin.getPlugin().getEventBroker().unregister(this.topicEventListener);
        super.dispose();
    }

    private class TableContentProvider
    extends StructuredContentProviderAdapter {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return SearchToolsView.this.extractorDescriptionMap.values().toArray();
        }
    }

    private class TableLabelProvider
    extends TableLabelProviderAdapter {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object obj, int idx) {
            LinkExtractorDescription led = (LinkExtractorDescription)obj;
            if (obj != null) {
                Image iconImage = null;
                try {
                    iconImage = SearchUIPlugin.getPlugin().getFavIcon(led.getName(), String.valueOf(led.getHomePageURL()) + "/favicon.ico");
                }
                catch (Throwable t) {
                    log.error("Failed to load favicon", t);
                }
                return iconImage;
            }
            return null;
        }

        public String getColumnText(Object obj, int idx) {
            LinkExtractorDescription led = (LinkExtractorDescription)obj;
            return led.getName();
        }
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if ("osint/search/linkExtractorDefinitionsChanged".equals(event.getTopic())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchToolsView.this.refresh();
                    }
                });
            }
        }
    }
}

