/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.wizard;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.ui.wizard.SelectFileWizardPageController;
import it.jrc.osint.util.ui.wizard.SelectProjectFolderWizardPageController;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class NetscapeBookmarkImportWizard
extends Wizard
implements IImportWizard {
    private static final Logger log = LogManager.getLogger((String)NetscapeBookmarkImportWizard.class.getName());
    private IStructuredSelection selection;
    private SelectFileWizardPageController selectFileController;
    private SelectProjectFolderWizardPageController selectFolderController;

    public void addPages() {
        super.addPages();
        this.selectFileController = new SelectFileWizardPageController();
        this.selectFileController.setPageTitle("Select file for import");
        this.selectFileController.setPageDescription("Select Firefox or IE bookmarks file");
        this.addPage(this.selectFileController.getView());
        this.selectFolderController = new SelectProjectFolderWizardPageController();
        this.selectFolderController.setFolder(this.getFolderFromSelection());
        this.selectFolderController.setPageTitle("Folder to import");
        this.selectFolderController.setPageDescription("Select folder to store imported bookmarks");
        this.selectFolderController.setPageFolderInputLabel("Select folder");
        this.addPage(this.selectFolderController.getView());
    }

    private IFolder getFolderFromSelection() {
        Object element;
        IFolder result = null;
        if (this.selection != null && (element = this.selection.getFirstElement()) instanceof IFolder) {
            return (IFolder)element;
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        if (this.selectFileController.hasFilePath() && this.selectFolderController.hasFolder()) {
            SearchService ss = SearchUIPlugin.getSearchService();
            OperationStatus result = ss.getImporter().importBookmarksFromNetscapeHTML(this.selectFileController.getFilePath(), this.selectFolderController.getFolder());
            return result == OperationStatus.OK_STATUS;
        }
        return false;
    }

    public boolean needsProgressMonitor() {
        return false;
    }
}

