/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.search.ui.wizard;

import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.ui.SearchUIPlugin;
import it.jrc.osint.util.ui.wizard.SelectFolderWizardPageController;
import it.jrc.osint.util.ui.wizard.SelectProjectFolderWizardPageController;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class XmlDocumentsExportWizardFolder
extends Wizard
implements IExportWizard {
    private IStructuredSelection selection;
    private SelectProjectFolderWizardPageController selectProjectFolderController;
    private SelectFolderWizardPageController selectFolderController;

    public void addPages() {
        super.addPages();
        this.selectProjectFolderController = new SelectProjectFolderWizardPageController();
        this.selectProjectFolderController.setFolder(this.getFolderFromSelection());
        this.selectProjectFolderController.setPageTitle("Folder to export");
        this.selectProjectFolderController.setPageDescription("Select folder containing documents to export.\nIMPORTANT: This folder must be under the 'Documents' folder.");
        this.selectProjectFolderController.setPageFolderInputLabel("Select folder");
        this.addPage(this.selectProjectFolderController.getView());
        this.selectFolderController = new SelectFolderWizardPageController();
        this.selectFolderController.setPageTitle("Export File Selection");
        this.selectFolderController.setPageDescription("Select the output folder where XML files will be generated");
        this.selectFolderController.setSaveDialog(true);
        this.addPage(this.selectFolderController.getView());
    }

    private IFolder getFolderFromSelection() {
        Object element;
        IFolder result = null;
        if (this.selection != null && (element = this.selection.getFirstElement()) instanceof IFolder) {
            return (IFolder)element;
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        if (this.selectFolderController.hasFilePath() && this.selectProjectFolderController.hasFolder()) {
            SearchService ss = SearchUIPlugin.getSearchService();
            OperationStatus result = ss.getExporter().exportDocumentsToXMLFolder(this.selectProjectFolderController.getFolder(), this.selectFolderController.getFilePath());
            return result == OperationStatus.OK_STATUS;
        }
        return false;
    }
}

