/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.cmatcher.ui.views;

import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.cmatcher.CategoryDatamodel;
import it.jrc.osint.cmatcher.CmatcherPlugin;
import it.jrc.osint.cmatcher.CmatcherService;
import it.jrc.osint.cmatcher.CmatcherServiceEvent;
import it.jrc.osint.cmatcher.DocumentCategoryRelation;
import it.jrc.osint.cmatcher.internal.Alerts;
import it.jrc.osint.cmatcher.ui.CmatcherUIPlugin;
import it.jrc.osint.cmatcher.ui.views.CategoryBrowserModel;
import it.jrc.osint.cmatcher.ui.views.CategoryBrowserView;
import it.jrc.osint.cmatcher.ui.views.DocForTreeViewer;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.ConfigProject;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.rss.SimpleElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CategoryBrowserController {
    private static final Logger log = LogManager.getLogger((String)CategoryBrowserController.class.getName());
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();
    private CategoryBrowserView view;
    private CategoryBrowserModel model;

    public CategoryBrowserController(CategoryBrowserView view) {
        this.view = view;
        this.model = new CategoryBrowserModel();
        this.model.setCategoriesLoaded(false);
    }

    public CategoryBrowserView getView() {
        return this.view;
    }

    public CategoryBrowserModel getModel() {
        return this.model;
    }

    public WorkspaceService getWorkspaceService() {
        return CmatcherPlugin.getWorkspaceService();
    }

    public void openDocument(ResourceId id, IWorkbenchPartSite partSite) {
        try {
            ICommandService cmdService = (ICommandService)partSite.getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)partSite.getService(IHandlerService.class);
            Command openDocView = cmdService.getCommand("osint.analysis.command.OpenDocumentViewer");
            IParameter urlParam = openDocView.getParameter("url");
            Parameterization parm = new Parameterization(urlParam, id.toString());
            ParameterizedCommand parmCommand = new ParameterizedCommand(openDocView, new Parameterization[]{parm});
            handlerService.executeCommand(parmCommand, null);
        }
        catch (Throwable t) {
            log.error("Failed to open document for id " + id, t);
        }
    }

    void onViewCreation() {
        CmatcherUIPlugin.getEventBroker().register(new String[]{"osint/cmatcher/categoryDatamodelChanged", "osint/cmatcher/categoriesLoaded", "osint/cmatcher/categoriesNotFound", "osint/cmatcher/activeConfigProjectNotFound", "osint/cmatcher/activeConfigProject"}, this.topicEventListener);
        log.debug("Category Browser View: onPartCreated");
        this.model.setReloadCategoryDatamodel(true);
    }

    public void onPartOpened() {
        log.debug("Category Browser View: onPartOpened");
        WorkspaceService ws = CmatcherPlugin.getWorkspaceService();
        ConfigProject cp = ws.getActiveConfigProject();
        this.model.setActiveConfigProject(cp);
        this.refreshView();
    }

    public void onPartBroughtToTop() {
    }

    public void onPartActivated() {
        log.debug("Category Browser View: onPartActivated");
        WorkspaceService ws = CmatcherPlugin.getWorkspaceService();
        ConfigProject cp = ws.getActiveConfigProject();
        this.model.setActiveConfigProject(cp);
        this.refreshView();
    }

    public void onPartClosed() {
        log.debug("Category Browser View: onPartClosed");
        this.model = null;
        this.view.removeListeners();
        CmatcherUIPlugin.getEventBroker().unregister(this.topicEventListener);
    }

    public void onPartDeactivated() {
        log.debug("Category Browser View: onPartDeactivated");
    }

    private void refreshView() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                CategoryBrowserController.this.performRefreshView();
            }
        });
    }

    private void performRefreshView() {
        this.view.setActiveConfigProject();
        if (this.model.getActiveConfigProject() == null) {
            this.view.disableComboCategories();
            this.view.showOneLineProgressMessage("A Config Project must be created");
            return;
        }
        if (!this.model.isCategoriesLoaded()) {
            this.view.disableComboCategories();
            this.view.showOneLineProgressMessage("No active categories found");
            return;
        }
        this.view.enableComboCategories();
        this.fillComboCategories();
        if (this.model.getSelectedCategory().length() == 0) {
            this.view.showOneLineProgressMessage("Please select a category");
            return;
        }
        this.view.setSelectCategory();
        if (this.model.getReloadCategoryDatamodel()) {
            this.view.showOneLineProgressMessage("Loading Data - please wait...");
            ArrayList<ResourceId> listDocResult = new ArrayList<ResourceId>();
            CategoryDatamodel cd = this.model.getCategoryDatamodel();
            if (cd != null) {
                if (cd.getAllCategoryRelations().size() == 0) {
                    this.view.showOneLineProgressMessage("No documents found");
                    return;
                }
                Set dcrs = cd.getAllCategoryRelations();
                if (this.model.getSelectedCategory() != null && this.model.getSelectedCategory().length() > 0) {
                    for (DocumentCategoryRelation dcr : dcrs) {
                        for (SimpleElement se : dcr.getCategories()) {
                            if (!se.getValue().equals(this.model.getSelectedCategory())) continue;
                            listDocResult.add(dcr.getDocumentId());
                        }
                    }
                }
            }
            DocForTreeViewer[] result = this.listResourceIdToArray(listDocResult);
            this.view.showCategoryMatcherResults(result);
            this.model.setReloadCategoryDatamodel(false);
        }
    }

    void setSelectedCategory(String selectedCategory) {
        if (!this.model.getSelectedCategory().equals(selectedCategory)) {
            this.getModel().setSelectedCategory(selectedCategory);
            this.model.setReloadCategoryDatamodel(true);
            this.refreshView();
        }
    }

    private void fillComboCategories() {
        CmatcherService cmatcher = CmatcherPlugin.getCmatcherService();
        List allCategories = cmatcher.getCategories();
        ArrayList<String> comboCategories = new ArrayList<String>();
        if (allCategories != null && allCategories.size() > 0) {
            for (Alerts tempAlerts : allCategories) {
                for (Alerts.AlertOSINT alert : tempAlerts.getAlerts()) {
                    comboCategories.add(alert.getId());
                }
            }
        }
        this.view.setComboCategories(comboCategories);
    }

    public DocForTreeViewer[] listResourceIdToArray(List<ResourceId> listdoc) {
        ArrayList<DocForTreeViewer> dataAllProjects = new ArrayList<DocForTreeViewer>();
        if (listdoc.size() == 0) {
            return dataAllProjects.toArray(new DocForTreeViewer[0]);
        }
        List caseProjects = this.getWorkspaceService().getCaseProjects();
        for (CaseProject cp : caseProjects) {
            String currentproject = cp.getName();
            ArrayList<DocForTreeViewer> projectarraylist = new ArrayList<DocForTreeViewer>();
            for (ResourceId tempdoc : listdoc) {
                if (!cp.getDocumentIds().contains(tempdoc)) continue;
                String doctitle = this.getDocTitle(tempdoc);
                String doctype = this.getDocType(tempdoc);
                projectarraylist.add(new DocForTreeViewer(doctitle, tempdoc.toString(), doctype));
            }
            if (projectarraylist.size() <= 0) continue;
            DocForTreeViewer dataProject = new DocForTreeViewer(currentproject, cp.getId().toString(), projectarraylist.toArray(new DocForTreeViewer[projectarraylist.size()]));
            dataAllProjects.add(dataProject);
        }
        DocForTreeViewer[] treeViewerResult = dataAllProjects.toArray(new DocForTreeViewer[dataAllProjects.size()]);
        return treeViewerResult;
    }

    public String getDocTitle(ResourceId doc) {
        WorkspaceService ws = CmatcherPlugin.getWorkspaceService();
        CaseProject cp = ws.getCaseProjectByDocumentId(doc);
        DocumentMetaItem dmi = cp.getMetaItem(doc);
        String title = dmi.getTitle();
        String link = dmi.getLink();
        if (title == null || title.length() == 0) {
            if (link != null) {
                String linkModified = link.replaceAll("http://", "").replaceAll("/", ".");
                return linkModified;
            }
            return "";
        }
        return title;
    }

    public String getDocType(ResourceId doc) {
        WorkspaceService ws = CmatcherPlugin.getWorkspaceService();
        CaseProject cp = ws.getCaseProjectByDocumentId(doc);
        IFile file = cp.getFile(doc);
        String location = file.getLocation().toOSString();
        return location.substring(location.length() - 3);
    }

    private void showInfoCategoryDatamodel(CategoryDatamodel cd) {
        System.out.println(" -------- INFO CATEGORYDATAMODEL ---------");
        System.out.println("  Total of CategoryRelations = " + cd.getAllCategoryRelations().size());
        Set setdcr = cd.getAllCategoryRelations();
        for (DocumentCategoryRelation dcr : setdcr) {
            Set cats = dcr.getCategories();
            System.out.print(" --- Doc '" + dcr.getDocumentId() + "': ");
            for (SimpleElement cat : cats) {
                System.out.print(String.valueOf(cat.getValue()) + ", ");
            }
            System.out.println("");
        }
        System.out.println(" -----------------------------------------");
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter
    implements TopicEventListener {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if (!(event instanceof CmatcherServiceEvent)) {
                return;
            }
            if ("osint/cmatcher/activeConfigProject".equals(event.getTopic())) {
                CategoryBrowserController.this.model.setActiveConfigProject(CmatcherPlugin.getWorkspaceService().getActiveConfigProject());
                CategoryBrowserController.this.refreshView();
            }
            if ("osint/cmatcher/activeConfigProjectNotFound".equals(event.getTopic())) {
                CategoryBrowserController.this.model.setActiveConfigProject(null);
                CategoryBrowserController.this.refreshView();
            }
            if ("osint/cmatcher/categoriesLoaded".equals(event.getTopic())) {
                CategoryBrowserController.this.model.setCategoriesLoaded(true);
                CategoryBrowserController.this.model.setSelectedCategory(new String());
                CategoryBrowserController.this.model.setReloadCategoryDatamodel(true);
                CategoryBrowserController.this.refreshView();
            }
            if ("osint/cmatcher/categoriesNotFound".equals(event.getTopic())) {
                CategoryBrowserController.this.model.setCategoriesLoaded(false);
                CmatcherService cmatcher = CmatcherPlugin.getCmatcherService();
                cmatcher.deleteAllCategories();
                CategoryBrowserController.this.refreshView();
            }
            if ("osint/cmatcher/categoryDatamodelChanged".equals(event.getTopic())) {
                CategoryBrowserController.this.model.setReloadCategoryDatamodel(true);
                CategoryBrowserController.this.refreshView();
            }
        }
    }
}

