/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.cmatcher.ui.wizards;

import it.jrc.osint.cmatcher.CmatcherPlugin;
import it.jrc.osint.cmatcher.ui.wizards.CategoryDefinitionFileCreationPage;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.ui.DialogUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewCategoryDefinitionFileWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "it.jrc.osint.cmatcher.ui.new.categoryDefinitionFile";
    private static final Logger log = LogManager.getLogger((String)CmatcherPlugin.class.getName());
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private CategoryDefinitionFileCreationPage fileCreationPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.workbench = workbench;
    }

    public boolean performFinish() {
        IFile file = this.fileCreationPage.createNewFile();
        if (file == null) {
            return false;
        }
        NewCategoryDefinitionFileWizard.selectAndReveal((IResource)file, this.getWorkbench().getActiveWorkbenchWindow());
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)dw.getShell(), (String)"Failed to create new Category Definition File", (String)e.getMessage(), (PartInitException)e);
        }
        return true;
    }

    private IStructuredSelection getSelection() {
        return this.selection;
    }

    private IWorkbench getWorkbench() {
        return this.workbench;
    }

    public void addPages() {
        super.addPages();
        this.fileCreationPage = new CategoryDefinitionFileCreationPage("CategoryDefinitionFileCreationPage", this.getSelection());
        this.addPage((IWizardPage)this.fileCreationPage);
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
        if (window == null || resource == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection((Object)resource);
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                @Override
                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }
}

