/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.console.ui.internal;

import it.jrc.osint.console.ConsoleEvent;
import it.jrc.osint.console.ui.OSINTConsoleUIPlugin;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;

public class EventMessageClient {
    private static final Logger log = LogManager.getLogger((String)EventMessageClient.class.getName());
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();
    private EventBroker eventBroker;

    public EventMessageClient(EventBroker eventBroker) {
        this.eventBroker = eventBroker;
        this.eventBroker.register(new String[]{"osint/console/messageReceived"}, this.topicEventListener);
    }

    public void stop() {
        this.eventBroker.unregister(this.topicEventListener);
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if ("osint/console/messageReceived".equals(event.getTopic())) {
                ConsoleEvent cEvent = (ConsoleEvent)event;
                try {
                    OSINTConsoleUIPlugin.getPlugin().getConsole().print(cEvent);
                }
                catch (Throwable t) {
                    log.error("Failed to print message to UI console", t);
                }
            }
        }
    }
}

