/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.update;

import it.jrc.osint.update.P2Policy;
import it.jrc.osint.update.SoftwareUpdatePreferences;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class UpdatePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "it.jrc.osint.update";
    private static UpdatePlugin plugin;
    private Policy policy;
    private ServiceRegistration policyRegistration;

    public static void log(IStatus status) {
        ILog log = UpdatePlugin.getPlugin().getLog();
        if (log != null) {
            log.log(status);
        } else {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
    }

    public static void log(Exception e) {
        UpdatePlugin.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerP2Policy(context);
    }

    private void registerP2Policy(BundleContext context) {
        this.policy = new P2Policy();
        this.policyRegistration = context.registerService(Policy.class.getName(), (Object)this.policy, null);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        context.ungetService(this.policyRegistration.getReference());
        super.stop(context);
    }

    public static UpdatePlugin getPlugin() {
        return plugin;
    }

    public SoftwareUpdatePreferences getPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean checkOnStartup = store.getBoolean("checkUpdateOnStartup");
        SoftwareUpdatePreferences prefs = new SoftwareUpdatePreferences();
        prefs.setCheckOnStartup(checkOnStartup);
        return prefs;
    }
}

