/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.update.handler;

import it.jrc.osint.update.handler.PreloadingRepositoryHandler;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.equinox.internal.p2.ui.dialogs.UpdateSingleIUWizard;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class UpdateHandler
extends PreloadingRepositoryHandler {
    boolean hasNoRepos = false;

    @Override
    protected void doExecute(LoadMetadataRepositoryJob job) {
        if (this.hasNoRepos) {
            return;
        }
        UpdateOperation operation = this.getProvisioningUI().getUpdateOperation(null, null);
        operation.resolveModal(null);
        if (this.getProvisioningUI().getPolicy().continueWorkingWithOperation((ProfileChangeOperation)operation, this.getShell())) {
            if (UpdateSingleIUWizard.validFor((UpdateOperation)operation)) {
                UpdateSingleIUWizard wizard = new UpdateSingleIUWizard(this.getProvisioningUI(), operation);
                WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            } else {
                this.getProvisioningUI().openUpdateWizard(false, operation, job);
            }
        }
    }

    @Override
    protected boolean preloadRepositories() {
        this.setRepositories();
        this.hasNoRepos = false;
        RepositoryTracker repoMan = this.getProvisioningUI().getRepositoryTracker();
        if (repoMan == null) {
            this.hasNoRepos = true;
            return false;
        }
        if (repoMan.getKnownRepositories(this.getProvisioningUI().getSession()).length == 0) {
            this.hasNoRepos = true;
            System.out.println("Has no repos");
            return false;
        }
        return super.preloadRepositories();
    }

    private void setRepositories() {
        try {
            String updateSite = "https://repository.emm4u.eu/osint/update/";
            MetadataRepositoryElement element = new MetadataRepositoryElement(null, new URI(updateSite), true);
            ElementUtils.updateRepositoryUsingElements((ProvisioningUI)this.getProvisioningUI(), (MetadataRepositoryElement[])new MetadataRepositoryElement[]{element});
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

