/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.ui.browser;

import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.search.SearchPlugin;
import it.jrc.osint.search.SearchService;
import it.jrc.osint.search.URLBookmark;
import it.jrc.osint.util.ui.PartListener2Adapter;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import java.net.URL;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.chromium.Browser;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.browser.WebBrowserEditor;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;

public class OSINTWebBrowserEditor
extends WebBrowserEditor {
    private static final Logger log = LogManager.getLogger((String)OSINTWebBrowserEditor.class.getName());
    public static final String EDITOR_ID = "it.jrc.osint.ui.browser.editor";
    private String initURL;
    private IPartListener2 partListener = new PartListener2Adapter(){

        public void partHidden(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof OSINTWebBrowserEditor && part == OSINTWebBrowserEditor.this) {
                log.debug("OSINTWebBrowserEditor hidden: " + OSINTWebBrowserEditor.this.getTitle());
                OSINTWebBrowserEditor.this.visible = false;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof OSINTWebBrowserEditor && part == OSINTWebBrowserEditor.this) {
                log.debug("OSINTWebBrowserEditor visible: " + OSINTWebBrowserEditor.this.getTitle());
                OSINTWebBrowserEditor.this.visible = true;
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof OSINTWebBrowserEditor && part == OSINTWebBrowserEditor.this) {
                SearchService sSvc = SearchPlugin.getSearchService();
                sSvc.signalURLLoaded();
            }
        }
    };
    private boolean visible;
    private ICommandService cmdService;
    private ISelectionListener selectionListener = new NavigatorSelectionListener();

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IEditorInput passThroughInput = input;
        if (input instanceof IFileEditorInput) {
            try {
                IFileEditorInput fei = (IFileEditorInput)input;
                IPath path = fei.getFile().getFullPath();
                if ("obm".equals(path.getFileExtension())) {
                    SearchService sSvc = SearchPlugin.getSearchService();
                    WorkspaceService wksSvc = WorkspacePlugin.getWorkspaceService();
                    ResourceId id = wksSvc.getId(path);
                    IFile bookmarkFile = wksSvc.getFile(id);
                    URLBookmark bookmark = sSvc.loadBookmark(bookmarkFile.getContents());
                    this.initURL = bookmark.getURL();
                    passThroughInput = new WebBrowserEditorInput(new URL(bookmark.getURL()), 6);
                }
            }
            catch (Throwable t) {
                log.error("Failed to load bookmark file", t);
            }
        }
        if (input instanceof WebBrowserEditorInput) {
            WebBrowserEditorInput wbInput = (WebBrowserEditorInput)input;
            URL inputURL = wbInput.getURL();
            this.initURL = inputURL != null ? wbInput.getURL().toString() : "about:blank";
        }
        super.init(site, passThroughInput);
        this.getSite().getPage().addPartListener(this.partListener);
        this.cmdService = (ICommandService)this.getSite().getService(ICommandService.class);
        ISelectionService selectionService = (ISelectionService)this.getSite().getService(ISelectionService.class);
        selectionService.addPostSelectionListener(this.selectionListener);
    }

    private void loadBookmarkFile(IFile bookmarkFile) {
        URLBookmark bookmark = null;
        try {
            SearchService sSvc = SearchPlugin.getSearchService();
            bookmark = sSvc.loadBookmark(bookmarkFile.getContents());
        }
        catch (CoreException e) {
            log.error("Failed to load bookmark file", (Throwable)e);
            return;
        }
        try {
            super.init((IEditorSite)this.getSite(), new WebBrowserEditorInput(new URL(bookmark.getURL()), 6));
        }
        catch (Throwable t) {
            log.error("Failed to init from bookmark file", t);
        }
    }

    public Browser getBrowser() {
        return this.webBrowser.getBrowser();
    }

    public String getURL() {
        String url = this.webBrowser.getURL();
        if ("about:blank".equals(url)) {
            return this.initURL;
        }
        return url;
    }

    @Override
    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        ISelectionService selectionService = (ISelectionService)this.getSite().getService(ISelectionService.class);
        selectionService.removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    private boolean isVisible() {
        return this.visible;
    }

    private boolean reuseEditor() {
        Command cmd = this.cmdService.getCommand("it.jrc.osint.ui.command.toggleReuseBrowser");
        State toggleState = cmd.getState("org.eclipse.ui.commands.toggleState");
        Boolean stateValue = (Boolean)toggleState.getValue();
        return stateValue;
    }

    private void onSelection(ISelection selection) {
        IFile aFile;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object selectedObj = structuredSelection.getFirstElement();
        if (selectedObj == null) {
            return;
        }
        if (selectedObj instanceof IFile && "obm".equals((aFile = (IFile)selectedObj).getFileExtension())) {
            this.loadBookmarkFile(aFile);
        }
    }

    private class NavigatorSelectionListener
    implements ISelectionListener {
        private NavigatorSelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            String sourcePartId = part.getSite().getId();
            if (sourcePartId == null) {
                return;
            }
            if (sourcePartId.equals("it.jrc.osint.ui.views.workspace") && OSINTWebBrowserEditor.this.isVisible() && OSINTWebBrowserEditor.this.reuseEditor()) {
                OSINTWebBrowserEditor.this.onSelection(selection);
            }
        }
    }
}

