/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.ui.browser;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.net.ProxyData;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.osgi.framework.Bundle;

public class XulRunnerHelper {
    private static final Logger log = LogManager.getLogger((String)XulRunnerHelper.class.getName());
    private static String XULRUNNER_BUNDLE_ID;
    private static final String FIREFOX_USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-GB; rv:1.9.2.24) Gecko/20111103 Firefox/3.6.24";
    private static XulRunnerHelper instance;
    public static final String HTTP_HEADER_USER_AGENT = "User-Agent";
    public static final String EVENT_HTTP_ON_EXAMINE_RESPONSE = "http-on-examine-response";
    public static final String EVENT_HTTP_ON_MODIFY_REQUEST = "http-on-modify-request";
    private int browserInstanceCount = 0;
    private ProxyData deferredSetProxyData;
    private static final String osName;
    private boolean deferredSetProxyDirectConnection;

    static {
        osName = System.getProperty("os.name");
    }

    public static XulRunnerHelper getInstance() {
        if (osName.startsWith("Windows")) {
            XULRUNNER_BUNDLE_ID = "org.mozilla.xulrunner.win32.win32.x86";
        } else if (osName.toLowerCase().startsWith("mac")) {
            XULRUNNER_BUNDLE_ID = "org.mozilla.xulrunner.macosx.cocoa.x86";
        }
        if (instance == null) {
            instance = new XulRunnerHelper();
        }
        return instance;
    }

    public String getXulRunnerRootPath() {
        File xulRunnerDir = XulRunnerHelper.getDirPathInBundle(XULRUNNER_BUNDLE_ID, "xulrunner");
        return xulRunnerDir.getAbsolutePath();
    }

    public static File getDirPathInBundle(String bundleId, String bundleRelativePath) {
        URL filePath;
        block5: {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return null;
            }
            filePath = bundle.getEntry(bundleRelativePath);
            if (filePath != null) break block5;
            return null;
        }
        try {
            URL localPath = FileLocator.resolve((URL)filePath);
            File pathInBundle = new File(FileLocator.toFileURL((URL)localPath).getFile());
            if (pathInBundle.isDirectory()) {
                return pathInBundle;
            }
        }
        catch (IOException e) {
            String message = "Invalid Xulrunner installed or not found in bundle:" + bundleId + " Exception: " + e.getMessage();
            Status status = new Status(4, bundleId, 4, message, (Throwable)e);
            WebBrowserUIPlugin.getInstance().getLog().log((IStatus)status);
        }
        return null;
    }

    public void setXulRunnerPathProperty() {
        String propertyKey = "org.eclipse.swt.browser.XULRunnerPath";
        String absolutePathToXulRunner = this.getXulRunnerRootPath();
        System.setProperty(propertyKey, absolutePathToXulRunner);
    }

    public synchronized void initBrowser(Browser browser) {
        this.setUserAgentString(FIREFOX_USER_AGENT);
        if (this.browserInstanceCount == 0) {
            ++this.browserInstanceCount;
            if (this.deferredSetProxyData != null) {
                this.setProxyData(this.deferredSetProxyData);
            }
            if (this.deferredSetProxyDirectConnection) {
                this.setProxyDirectConnection();
            }
        } else {
            ++this.browserInstanceCount;
        }
        this.initBrowserContextMenu(browser);
    }

    private void initBrowserContextMenu(Browser browser) {
    }

    public void setProxyDirectConnection() {
    }

    public void setProxyData(ProxyData proxyData) {
        if (this.browserInstanceCount == 0) {
            this.deferredSetProxyData = proxyData;
        } else {
            this.setProxyData(proxyData.getProxyHost(), proxyData.getProxyPort(), proxyData.getNonProxiedHostsList(), "", proxyData.getUserId(), proxyData.getUserPassword());
        }
    }

    private void setUserAgentString(String userAgent) {
    }

    private void setProxyData(String proxyHost, int proxyPort, String noProxyList, String realm, String username, String password) {
    }
}

