/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserDescriptor;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.IBrowserExt;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.osgi.framework.Version;

public class WebBrowserUtil {
    private static final String BROWSER_PACKAGE_NAME = "org.eclipse.swt.browser.Browser";
    public static Boolean isInternalBrowserOperational;
    private static final char STYLE_SEP = '-';
    private static final int DEFAULT_STYLE = 6;

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") >= 0;
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("lin") >= 0;
    }

    public static void openError(String message) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Shell shell = d.getActiveShell();
        MessageDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message);
    }

    public static void openMessage(String message) {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        Shell shell = d.getActiveShell();
        MessageDialog.openInformation((Shell)shell, (String)Messages.searchingTaskName, (String)message);
    }

    public static boolean canUseInternalWebBrowser() {
        if (isInternalBrowserOperational != null) {
            return isInternalBrowserOperational;
        }
        try {
            Class.forName(BROWSER_PACKAGE_NAME);
        }
        catch (ClassNotFoundException e) {
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        Shell shell = null;
        try {
            shell = new Shell(PlatformUI.getWorkbench().getDisplay());
            new Browser((Composite)shell, 0);
            isInternalBrowserOperational = new Boolean(true);
            return true;
        }
        catch (Throwable t) {
            StringBuffer message = new StringBuffer("Internal browser is not available");
            message.append(t.getMessage() == null ? "." : ": " + t.getMessage());
            WebBrowserUIPlugin.getInstance().getLog().log((IStatus)new Status(2, "org.eclipse.ui.browser", 0, message.toString(), null));
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    public static boolean canUseSystemBrowser() {
        if ("solaris".equals(Platform.getOS())) {
            if (!"gtk".equals(Platform.getWS())) {
                return false;
            }
            String osVersion = WebBrowserUIPlugin.getInstance().getBundle().getBundleContext().getProperty("org.osgi.framework.os.version");
            int compareVal = new Version(osVersion).compareTo(new Version(5, 10, 0));
            if (compareVal < 0) {
                return false;
            }
        }
        return Program.findProgram((String)"html") != null;
    }

    public static List<String> getExternalBrowserPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        for (IBrowserDescriptor wb : BrowserManager.getInstance().getWebBrowsers()) {
            if (wb == null || wb.getLocation() == null) continue;
            paths.add(wb.getLocation().toLowerCase());
        }
        return paths;
    }

    public static void addFoundBrowsers(List<IBrowserDescriptor> browsers2) {
        List<String> paths = WebBrowserUtil.getExternalBrowserPaths();
        String os = Platform.getOS();
        File[] roots = WebBrowserUtil.getUsableDrives(File.listRoots());
        IBrowserExt[] browsers = WebBrowserUIPlugin.getBrowsers();
        int size = browsers.length;
        int i = 0;
        while (i < size) {
            IBrowserExt browserExt = browsers[i];
            String[] locations = browserExt.getDefaultLocations();
            if (locations != null && browserExt.getOS().toLowerCase().indexOf(os) >= 0) {
                int size2 = locations.length;
                int j = 0;
                while (j < size2) {
                    String location = locations[j];
                    String foundBrowserPath = WebBrowserUtil.locateBrowser(paths, location, roots);
                    if (foundBrowserPath != null) {
                        BrowserDescriptor descriptor = new BrowserDescriptor();
                        descriptor.name = browserExt.getName();
                        descriptor.location = foundBrowserPath;
                        descriptor.parameters = browserExt.getParameters();
                        browsers2.add(descriptor);
                        j += size2;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static String locateBrowser(List<String> alreadyFoundPaths, String location, File[] searchRoots) {
        int envVarEnd;
        int rootSize = searchRoots.length;
        if (Util.isWindows() && location.startsWith("%") && (envVarEnd = location.indexOf(37, 1)) != -1) {
            try {
                String expanded = System.getenv(location.substring(1, envVarEnd));
                if (expanded != null) {
                    File f = new File(String.valueOf(expanded) + location.substring(envVarEnd + 1));
                    String absolutePath = f.getAbsolutePath();
                    if (!alreadyFoundPaths.contains(absolutePath.toLowerCase()) && f.exists()) {
                        return absolutePath;
                    }
                    return null;
                }
            }
            catch (Exception expanded) {
                // empty catch block
            }
        }
        int k = 0;
        while (k < rootSize) {
            try {
                File f = new File(searchRoots[k], location);
                String absolutePath = f.getAbsolutePath();
                if (!alreadyFoundPaths.contains(absolutePath.toLowerCase()) && f.exists()) {
                    return absolutePath;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++k;
        }
        return null;
    }

    private static File[] getUsableDrives(File[] roots) {
        if (!Platform.getOS().equals("win32")) {
            return roots;
        }
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < roots.length) {
            String path = roots[i].getAbsolutePath();
            if (path == null || !path.toLowerCase().startsWith("a:") && !path.toLowerCase().startsWith("b:")) {
                list.add(roots[i]);
            }
            ++i;
        }
        return list.toArray(new File[list.size()]);
    }

    public static IBrowserDescriptorWorkingCopy createExternalBrowser(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        String executable = file.getName();
        IBrowserExt[] browsers = WebBrowserUIPlugin.getBrowsers();
        int size = browsers.length;
        int i = 0;
        while (i < size) {
            if (executable.equals(browsers[i].getExecutable())) {
                IBrowserDescriptorWorkingCopy browser = BrowserManager.getInstance().createExternalWebBrowser();
                browser.setName(browsers[i].getName());
                browser.setLocation(file.getAbsolutePath());
                browser.setParameters(browsers[i].getParameters());
                return browser;
            }
            ++i;
        }
        return null;
    }

    public static String encodeStyle(String browserId, int style) {
        return String.valueOf(browserId) + '-' + style;
    }

    public static int decodeStyle(String secondaryId) {
        int sep;
        if (secondaryId != null && (sep = secondaryId.lastIndexOf(45)) != -1) {
            String stoken = secondaryId.substring(sep + 1);
            try {
                return Integer.parseInt(stoken);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 6;
    }

    public static String decodeId(String encodedId) {
        int sep = encodedId.lastIndexOf(45);
        if (sep != -1) {
            return encodedId.substring(0, sep);
        }
        return encodedId;
    }

    public static String createParameterString(String parameters, String urlText) {
        int urlIndex;
        String params = parameters;
        String url = urlText;
        if (url == null) {
            url = "";
        }
        if (params == null) {
            params = "";
        }
        if ((urlIndex = params.indexOf("%URL%")) >= 0) {
            params = String.valueOf(params.substring(0, urlIndex)) + url + params.substring(urlIndex + "%URL%".length());
        } else {
            if (params.length() != 0 && !params.endsWith(" ")) {
                params = String.valueOf(params) + " ";
            }
            params = String.valueOf(params) + url;
        }
        return params;
    }
}

