/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.EventBroker;
import it.jrc.osint.workspace.ProjectCreationParticipant;
import it.jrc.osint.workspace.ResourceBuilder;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.internal.ResourceMonitorServiceImpl;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;

public class WorkspacePlugin
extends Plugin {
    public static final String PLUGIN_ID = "it.jrc.osint.workspace";
    private static final Logger log = LogManager.getLogger((String)WorkspacePlugin.class.getName());
    private static final String PROJECT_CREATION_PARTICIPANT_EXTENSION_ID = "projectCreationParticipant";
    private static final String RESOURCE_BUILDER_EXTENSION_ID = "resourceBuilder";
    private static WorkspacePlugin plugin;
    private EventBroker eventBroker;
    private ResourceMonitorServiceImpl resourceMonitorService;
    private WorkspaceServiceImpl workspaceService;
    private boolean projectCreationParticipantExtensionsLoaded;
    private List<ProjectCreationParticipant> projectCreationParticipants = new ArrayList<ProjectCreationParticipant>();
    private SortedSet<ResourceBuilderRegistration> resourceBuilderRegistrations = new TreeSet<ResourceBuilderRegistration>();
    private IEclipsePreferences preferences;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.eventBroker = new EventBroker(context);
        this.preferences = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        this.startServices();
    }

    public static WorkspacePlugin getPlugin() {
        return plugin;
    }

    private void startServices() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.putBoolean("refresh.enabled", true);
        prefs.putBoolean("description.disableLinking", true);
        try {
            IWorkspace wks = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription wksDesc = wks.getDescription();
            if (!wksDesc.isAutoBuilding()) {
                wksDesc.setAutoBuilding(true);
                wks.setDescription(wksDesc);
            }
        }
        catch (CoreException e) {
            log.error("Failed to enable auto build", (Throwable)e);
        }
        this.workspaceService = new WorkspaceServiceImpl(this.eventBroker);
        this.workspaceService.start();
        this.resourceMonitorService = new ResourceMonitorServiceImpl();
        this.resourceMonitorService.start();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.resourceMonitorService != null) {
            this.resourceMonitorService.stop();
        }
        if (this.workspaceService != null) {
            this.workspaceService.stop();
        }
        if (this.eventBroker != null) {
            this.eventBroker.stop();
        }
    }

    public static Object getResourceMonitorService() {
        return WorkspacePlugin.getPlugin().resourceMonitorService;
    }

    public static WorkspaceService getWorkspaceService() {
        return WorkspacePlugin.getPlugin().workspaceService;
    }

    public void saveOnExit() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (Exception e) {
            log.error("Save on exit or workspace failed", (Throwable)e);
        }
    }

    public synchronized List<ProjectCreationParticipant> getProjectCreationParticipants() {
        this.loadProjectCreationParticipantExtensions();
        return this.projectCreationParticipants;
    }

    public synchronized List<ResourceBuilder> getResourceBuilders() {
        return this.loadResourceBuilderExtensions();
    }

    public IEclipsePreferences getPreferences() {
        return this.preferences;
    }

    private List<ResourceBuilder> loadResourceBuilderExtensions() {
        ArrayList<ResourceBuilder> resourceBuilders = new ArrayList<ResourceBuilder>();
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("it.jrc.osint.workspace.resourceBuilder");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                int priority = 0;
                String priorityAttr = e.getAttribute("priority");
                if (priorityAttr != null) {
                    try {
                        priority = Integer.parseInt(e.getAttribute("priority"));
                    }
                    catch (Throwable t) {
                        log.error("Invalid configuration attribute priority", t);
                    }
                }
                this.resourceBuilderRegistrations.add(new ResourceBuilderRegistration((ResourceBuilder)o, priority));
                ++n2;
            }
        }
        catch (Exception e) {
            log.error("Failed to load text extractor extensions", (Throwable)e);
        }
        for (ResourceBuilderRegistration rg : this.resourceBuilderRegistrations) {
            resourceBuilders.add(rg.getResourceBuilder());
        }
        return resourceBuilders;
    }

    private void loadProjectCreationParticipantExtensions() {
        if (this.projectCreationParticipantExtensionsLoaded) {
            return;
        }
        this.projectCreationParticipantExtensionsLoaded = true;
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("it.jrc.osint.workspace.projectCreationParticipant");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                this.projectCreationParticipants.add((ProjectCreationParticipant)o);
                ++n2;
            }
        }
        catch (Exception e) {
            log.error("Failed to load text extractor extensions", (Throwable)e);
        }
    }

    private class ResourceBuilderRegistration
    implements Comparable<ResourceBuilderRegistration> {
        private ResourceBuilder rb;
        private int priority;

        public ResourceBuilderRegistration(ResourceBuilder rb, int priority) {
            this.rb = rb;
            this.priority = priority;
        }

        @Override
        public int compareTo(ResourceBuilderRegistration otherRB) {
            if (otherRB.getPriority() > this.priority) {
                return 1;
            }
            if (otherRB.getPriority() == this.priority) {
                return 0;
            }
            return -1;
        }

        public ResourceBuilder getResourceBuilder() {
            return this.rb;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

