/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.jrc.osint.DocumentMetaItem;
import it.jrc.osint.ResourceId;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.operations.OperationStatus;
import it.jrc.osint.util.concurrent.Consumer;
import it.jrc.osint.util.concurrent.Producer;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.osint.workspace.CaseProject;
import it.jrc.osint.workspace.ErrorConditions;
import it.jrc.osint.workspace.WorkspacePlugin;
import it.jrc.osint.workspace.WorkspaceService;
import it.jrc.osint.workspace.WorkspaceUtil;
import it.jrc.osint.workspace.internal.BaseProjectImpl;
import it.jrc.osint.workspace.internal.CaseProjectLayout;
import it.jrc.osint.workspace.internal.DocumentRepository;
import it.jrc.osint.workspace.internal.DocumentRepositoryConsumer;
import it.jrc.osint.workspace.internal.DocumentRepositoryProducer;
import it.jrc.osint.workspace.internal.FileImportJob;
import it.jrc.osint.workspace.internal.ProjectLayout;
import it.jrc.osint.workspace.internal.WorkspaceServiceEventImpl;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.MultiRule;

class CaseProjectImpl
extends BaseProjectImpl
implements CaseProject {
    private static final Logger log = LogManager.getLogger((String)CaseProjectImpl.class.getName());
    private DocumentRepository docRepository;
    private ProjectLayout layout;
    private Cache<String, IFolder> folderCorrelationCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    CaseProjectImpl(ResourceId projectId, WorkspaceServiceImpl workspaceService, String name) {
        super(projectId, workspaceService, name);
        this.layout = new CaseProjectLayout();
    }

    @Override
    protected ProjectLayout getProjectLayout() {
        return this.layout;
    }

    @Override
    protected ResourceId fileAdded_rm(IFile aFile) {
        return this.docRepository.fileAdded_rm(aFile);
    }

    @Override
    protected ResourceId fileDeleted_rm(IFile aFile) {
        return this.docRepository.fileDeleted_rm(aFile);
    }

    @Override
    protected ResourceId fileMoved_rm(IFile toFile, IPath fromPath) {
        String fromProjectName = fromPath.segment(0);
        String toProjectName = toFile.getProject().getName();
        if (this.getName().equals(fromProjectName) && !this.getName().equals(toProjectName)) {
            return this.docRepository.fileDeleted_rm(toFile);
        }
        if (!this.getName().equals(fromProjectName) && this.getName().equals(toProjectName)) {
            DocumentMetaItem item;
            ResourceId id = this.workspaceService.getFileIndex().getId(toFile.getFullPath());
            CaseProject sourceProject = this.workspaceService.getCaseProjectByName(fromProjectName);
            if (sourceProject != null && (item = sourceProject.getMetaItem(id)) != null) {
                this.saveMetaItem(item);
            }
            return this.docRepository.fileAdded_rm(toFile);
        }
        if (this.getName().equals(fromProjectName) && this.getName().equals(toProjectName)) {
            return this.docRepository.fileMovedWithin_rm(toFile, fromPath);
        }
        return null;
    }

    @Override
    protected ResourceId fileUpdated_rm(IFile aFile) {
        return this.docRepository.fileUpdated_rm(aFile);
    }

    @Override
    public Set<ResourceId> getDocumentIds() {
        return this.docRepository.getResourceIds();
    }

    @Override
    public boolean containsDocument(IPath aPath) {
        return this.docRepository.contains(aPath);
    }

    @Override
    public boolean containsDocument(ResourceId resourceId) {
        return this.docRepository.contains(resourceId);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    void start() {
        this.docRepository = new DocumentRepository(this, this.getDocumentsFolder().getProjectRelativePath());
        this.docRepository.compact();
    }

    private IFolder getDocumentsFolder() {
        IPath projectRelativeFolder = this.getProjectLayout().getFolderPath("Documents");
        return this.getProject().getFolder(projectRelativeFolder);
    }

    void stop() {
    }

    @Override
    public boolean isCaseProject() {
        return true;
    }

    @Override
    public boolean isConfigProject() {
        return false;
    }

    @Override
    public void dumpMetaItem(IFile aFile) {
        this.docRepository.dumpMetaItem(aFile);
    }

    @Override
    public void importFiles(List<File> files, List<DocumentMetaItem> metaItems, IPath parentFolderPath, String correlationId) {
        if (files == null || files.isEmpty()) {
            return;
        }
        log.debug("Importing " + files.size() + " files and " + metaItems.size() + " meta items");
        if (parentFolderPath == null) {
            throw new IllegalArgumentException("Path of parent folder is null");
        }
        IPath docFolderPath = this.getDocumentFolderPath();
        if (!docFolderPath.isPrefixOf(parentFolderPath)) {
            throw new IllegalArgumentException("Parent folder path is outside of document folder");
        }
        IPath docFolderRelativePath = parentFolderPath.makeRelativeTo(docFolderPath);
        IFolder importFolder = null;
        if (correlationId != null) {
            try {
                importFolder = (IFolder)this.folderCorrelationCache.get((Object)correlationId, (Callable)new AddFolderCallable((IContainer)this.getDocumentsFolder(), docFolderRelativePath.toString()));
            }
            catch (ExecutionException e) {
                log.error("Failed to retriev folder for correlation id", (Throwable)e);
                importFolder = this.addUniqueFolder((IContainer)this.getDocumentsFolder(), docFolderRelativePath.toString(), null);
            }
        } else {
            importFolder = this.addUniqueFolder((IContainer)this.getDocumentsFolder(), docFolderRelativePath.toString(), null);
        }
        try {
            FileImportJob importJob = new FileImportJob(this, files, metaItems, importFolder);
            MultiRule rule = new MultiRule((ISchedulingRule[])new IResource[]{importFolder, this.docRepository.getMetaFolder()});
            importJob.setRule((ISchedulingRule)rule);
            importJob.setUser(false);
            importJob.schedule();
        }
        catch (Throwable t) {
            log.error("Failed to import file", t);
        }
    }

    @Override
    public IPath getDocumentFolderPath() {
        return this.getDocumentsFolder().getFullPath();
    }

    void fireMetaDataChangedEvent(Set<ResourceId> ids) {
        WorkspaceServiceImpl ws = (WorkspaceServiceImpl)WorkspacePlugin.getWorkspaceService();
        ResourceId projectId = ws.getFileIndex().getId(this.getProject().getFullPath());
        WorkspaceServiceEventImpl newEvent = new WorkspaceServiceEventImpl("osint/workspace/metaDataChanged", projectId, this.getProject().getName());
        newEvent.setResourceIds(ids);
        ws.fireWorkspaceEvent(newEvent);
    }

    @Override
    public Producer<DocumentMetaItem> getMetaItemProducer() {
        Set<ResourceId> idsToProduce = this.getDocumentIds();
        return this.getMetaItemProducer(idsToProduce);
    }

    @Override
    public Producer<DocumentMetaItem> getMetaItemProducer(Set<ResourceId> ids) {
        Set<ResourceId> idsToProduce = ids;
        if (ids == null) {
            idsToProduce = new HashSet<ResourceId>();
        }
        DocumentRepositoryProducer producer = new DocumentRepositoryProducer(this.docRepository, idsToProduce);
        producer.setContext(null);
        return producer;
    }

    @Override
    public Consumer<DocumentMetaItem> getMetaItemConsumer() {
        DocumentRepositoryConsumer consumer = new DocumentRepositoryConsumer(this.docRepository);
        consumer.setContext(null);
        return consumer;
    }

    @Override
    public boolean hasMetaItem(ResourceId id) {
        return this.docRepository.hasMetaItem(id);
    }

    @Override
    public DocumentMetaItem getMetaItem(ResourceId id) {
        return this.docRepository.getMetaItem(id);
    }

    @Override
    public void saveMetaItem(DocumentMetaItem metaItem) {
        this.docRepository.saveMetaItem(metaItem);
    }

    @Override
    public void saveMetaItems(List<DocumentMetaItem> metaItems) {
        this.docRepository.saveMetaItems(metaItems);
    }

    @Override
    public void saveMetaItem_rm(DocumentMetaItem metaItem) {
        this.docRepository.saveMetaItem_rm(metaItem);
    }

    @Override
    public OperationStatus saveFile(IPath filePath, final InputStream contents, boolean overwrite) {
        IPath savePath = filePath;
        boolean invalidPath = false;
        try {
            IStatus status;
            if (!this.getProject().getFullPath().isPrefixOf(savePath)) {
                invalidPath = true;
            }
            if (this.getDocumentFolderPath().isPrefixOf(savePath)) {
                invalidPath = true;
            }
            if (!(status = ResourcesPlugin.getWorkspace().validatePath(savePath.toString(), 1)).isOK()) {
                invalidPath = true;
            }
        }
        catch (Throwable t) {
            log.error("Failed to validate file path", t);
            invalidPath = true;
        }
        if (invalidPath) {
            FileUtil.close((InputStream)contents);
            return new OperationStatus(ErrorConditions.get(ErrorConditions.INVALID_PATH));
        }
        IFile testFile = ResourcesPlugin.getWorkspace().getRoot().getFile(savePath);
        if (!overwrite) {
            String adpatedFileName;
            IContainer parentContainer = testFile.getParent();
            String currentFileName = savePath.lastSegment();
            if (!currentFileName.equals(adpatedFileName = WorkspaceUtil.getNextFileName(parentContainer, currentFileName, 0))) {
                savePath = parentContainer.getFullPath().append(adpatedFileName);
            }
        }
        final IFile saveFile = ResourcesPlugin.getWorkspace().getRoot().getFile(savePath);
        try {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        block9: {
                            if (monitor != null) {
                                monitor.beginTask("Saving report file", -1);
                            }
                            try {
                                try {
                                    if (saveFile.exists()) {
                                        saveFile.setContents(contents, true, false, monitor);
                                        break block9;
                                    }
                                    saveFile.create(contents, true, monitor);
                                }
                                catch (Throwable t) {
                                    log.error("Failed to save file in project", t);
                                    if (monitor != null) {
                                        monitor.done();
                                    }
                                    FileUtil.close((InputStream)contents);
                                }
                            }
                            finally {
                                if (monitor != null) {
                                    monitor.done();
                                }
                                FileUtil.close((InputStream)contents);
                            }
                        }
                    }
                }, (ISchedulingRule)this.getProject(), 1, null);
            }
            catch (Throwable t) {
                OperationStatus operationStatus = new OperationStatus(ErrorConditions.get(ErrorConditions.FILE_SAVE_FAILED));
                FileUtil.close((InputStream)contents);
                return operationStatus;
            }
        }
        finally {
            FileUtil.close((InputStream)contents);
        }
        return OperationStatus.OK_STATUS;
    }

    DocumentRepository getDocumentRepository() {
        return this.docRepository;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof CaseProjectImpl) {
            CaseProjectImpl otherPrj = (CaseProjectImpl)other;
            return this.getId().equals((Object)otherPrj.getId());
        }
        return false;
    }

    @Override
    public Producer<DocumentMetaItem> getMetaItemProducer(String markerType) {
        Set<ResourceId> markedDocuments = this.getMarkedDocuments(null, markerType);
        return this.getMetaItemProducer(markedDocuments);
    }

    private Set<ResourceId> getMarkedDocuments(IResource buildParentResource, String markerType) {
        HashSet<ResourceId> docIds = new HashSet<ResourceId>();
        try {
            IMarker[] extractionMarkers;
            if (buildParentResource == null) {
                buildParentResource = this.getSystemFolder("Documents");
            }
            if ((extractionMarkers = buildParentResource.findMarkers(markerType, true, 2)) == null || extractionMarkers.length == 0) {
                return docIds;
            }
            IMarker[] iMarkerArray = extractionMarkers;
            int n = extractionMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker aMarker = iMarkerArray[n2];
                IResource markedResource = aMarker.getResource();
                if (markedResource.exists()) {
                    WorkspaceService ws = WorkspacePlugin.getWorkspaceService();
                    ResourceId docId = ws.getId(markedResource.getFullPath());
                    docIds.add(docId);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error("Failed to retrieve markers ", (Throwable)e);
        }
        return docIds;
    }

    @Override
    public void fullBuild() {
        HashMap<String, String> builderArgs = new HashMap<String, String>();
        builderArgs.put("userAction", Boolean.TRUE.toString());
        BuildJob job = new BuildJob(6, builderArgs);
        job.schedule();
    }

    @Override
    public void incrementalBuild(String parentPath) {
        HashMap<String, String> builderArgs = new HashMap<String, String>();
        builderArgs.put("userAction", Boolean.TRUE.toString());
        builderArgs.put("partialBuildPath", parentPath);
        BuildJob job = new BuildJob(10, builderArgs);
        job.schedule();
    }

    @Override
    public void cleanAndBuild() {
        HashMap<String, String> builderArgs = new HashMap<String, String>();
        builderArgs.put("userAction", Boolean.TRUE.toString());
        BuildJob job = new BuildJob(15, builderArgs);
        boolean automaticExtractionEnabled = WorkspacePlugin.getWorkspaceService().isAutomaticExtractionEnabled();
        if (!automaticExtractionEnabled) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        CaseProjectImpl.this.fullBuild();
                    }
                }
            });
        }
        job.schedule();
    }

    @Override
    public void clean() {
        HashMap<String, String> builderArgs = new HashMap<String, String>();
        BuildJob job = new BuildJob(15, builderArgs);
        job.schedule();
    }

    private class AddFolderCallable
    implements Callable<IFolder> {
        private IContainer documentsFolder;
        private String newFolderRelativePath;

        public AddFolderCallable(IContainer documentsFolder, String newFolderRelativePath) {
            this.documentsFolder = documentsFolder;
            this.newFolderRelativePath = newFolderRelativePath;
        }

        @Override
        public IFolder call() throws Exception {
            return CaseProjectImpl.this.addUniqueFolder(this.documentsFolder, this.newFolderRelativePath, null);
        }
    }

    private class BuildJob
    extends Job {
        private Map<String, String> builderArgs;
        private int kind;

        public BuildJob(int kind, Map<String, String> builderArgs) {
            super("Information Extraction");
            this.kind = kind;
            this.builderArgs = builderArgs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                CaseProjectImpl.this.getProject().build(this.kind, "it.jrc.osint.workspace.caseProjectBuilder", this.builderArgs, monitor);
            }
            catch (Throwable t) {
                log.error("Failed to start build job", t);
                return new Status(4, "it.jrc.osint.workspace", "Failed to start build job");
            }
            return Status.OK_STATUS;
        }
    }
}

