/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.ResourceId;
import it.jrc.osint.workspace.ConfigProject;
import it.jrc.osint.workspace.ResourceEvent;
import it.jrc.osint.workspace.WorkspaceServiceEvent;
import it.jrc.osint.workspace.internal.BaseProjectImpl;
import it.jrc.osint.workspace.internal.ConfigProjectLayout;
import it.jrc.osint.workspace.internal.ProjectLayout;
import it.jrc.osint.workspace.internal.WorkspaceServiceEventImpl;
import it.jrc.osint.workspace.internal.WorkspaceServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

class ConfigProjectImpl
extends BaseProjectImpl
implements ConfigProject {
    private ProjectLayout layout = new ConfigProjectLayout();

    ConfigProjectImpl(ResourceId projectId, WorkspaceServiceImpl workspaceService, String name) {
        super(projectId, workspaceService, name);
    }

    @Override
    public boolean isCaseProject() {
        return false;
    }

    @Override
    public boolean isConfigProject() {
        return true;
    }

    @Override
    protected ProjectLayout getProjectLayout() {
        return this.layout;
    }

    @Override
    protected ResourceId fileAdded_rm(IFile aFile) {
        return this.workspaceService.getId(aFile.getFullPath());
    }

    @Override
    protected ResourceId fileDeleted_rm(IFile aFile) {
        return this.workspaceService.getId(aFile.getFullPath());
    }

    @Override
    protected ResourceId fileMoved_rm(IFile toFile, IPath fromPath) {
        return this.workspaceService.getId(toFile.getFullPath());
    }

    @Override
    protected ResourceId fileUpdated_rm(IFile aFile) {
        return this.workspaceService.getId(aFile.getFullPath());
    }

    @Override
    public void update(List<ResourceEvent> resourceEvents, boolean projectDeleted, List<WorkspaceServiceEvent> outEvents) {
        ArrayList<WorkspaceServiceEvent> wsEvents = new ArrayList<WorkspaceServiceEvent>();
        super.update(resourceEvents, projectDeleted, wsEvents);
        outEvents.addAll(wsEvents);
        Set<ResourceId> changedConfigResources = this.getChangedConfigResourceIds(wsEvents);
        if (!changedConfigResources.isEmpty()) {
            WorkspaceServiceEventImpl newEvent = new WorkspaceServiceEventImpl("osint/workspace/activeConfigProjectContentChanged", this.getId(), this.getName());
            newEvent.setResourceIds(changedConfigResources);
            newEvent.setProjectDeleted(projectDeleted);
            outEvents.add(newEvent);
            if (changedConfigResources.size() > 1) {
                WorkspaceServiceEventImpl refreshEvent = new WorkspaceServiceEventImpl("osint/workspace/refreshUI");
                outEvents.add(refreshEvent);
            }
        }
    }

    private Set<ResourceId> getChangedConfigResourceIds(List<WorkspaceServiceEvent> events) {
        HashSet<ResourceId> changedConfigResourceIds = new HashSet<ResourceId>();
        for (WorkspaceServiceEvent event : events) {
            if (!this.getId().equals((Object)event.getProjectId())) continue;
            changedConfigResourceIds.addAll(event.getResourceIds());
        }
        return changedConfigResourceIds;
    }
}

