/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.workspace.internal;

import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public class DebugResourceMonitorListener
implements IResourceChangeListener {
    private static final Logger log = LogManager.getLogger((String)DebugResourceMonitorListener.class.getName());

    public void dumpResourceDelta(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    StringBuffer buf = new StringBuffer(80);
                    switch (delta.getKind()) {
                        case 1: {
                            buf.append("ADDED");
                            break;
                        }
                        case 2: {
                            buf.append("REMOVED");
                            break;
                        }
                        case 4: {
                            buf.append("CHANGED");
                            break;
                        }
                        default: {
                            buf.append("[");
                            buf.append(delta.getKind());
                            buf.append("]");
                        }
                    }
                    buf.append(" ");
                    buf.append(DebugResourceMonitorListener.this.dumpResourceDeltaFlags(delta));
                    buf.append(delta.getResource());
                    log.debug(buf.toString());
                    DebugResourceMonitorListener.this.dumpResourceProperties(delta.getResource());
                    return true;
                }
            });
        }
        catch (CoreException e) {
            log.error("Failed to collect resource change", (Throwable)e);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        this.dumpResourceDelta(delta);
    }

    private void dumpResourceProperties(IResource resource) {
        if (resource == null) {
            return;
        }
        if (!resource.exists()) {
            return;
        }
        try {
            Map persistantProperties = resource.getPersistentProperties();
            for (Map.Entry entry : persistantProperties.entrySet()) {
                log.debug("Property " + ((QualifiedName)entry.getKey()).toString() + " : " + (String)persistantProperties.get(entry.getKey()));
            }
        }
        catch (Throwable t) {
            log.error("Failed to dump resource properties", t);
        }
    }

    private String dumpResourceDeltaFlags(IResourceDelta delta) {
        StringBuffer buf = new StringBuffer();
        try {
            IPath movedFromPath;
            int flags = delta.getFlags();
            buf.append("(");
            if ((flags & 0x1000) == 4096) {
                buf.append("MF=");
                movedFromPath = delta.getMovedFromPath();
                if (movedFromPath != null) {
                    buf.append(movedFromPath.toString());
                }
            }
            if ((flags & 0x2000) == 8192) {
                buf.append("MT=");
                movedFromPath = delta.getMovedFromPath();
                if (movedFromPath != null) {
                    buf.append(movedFromPath.toString());
                }
            }
            buf.append(")");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buf.toString();
    }
}

