/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.analysis.graph;

import it.jrc.osint.ResourceId;
import it.jrc.osint.analysis.graph.EntityEntityEdge;
import it.jrc.osint.analysis.graph.RelationshipGraph;
import it.jrc.osint.analysis.relation.DocumentEntityRelation;
import it.jrc.osint.extract.entities.Entity;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.jgrapht.EdgeFactory;

public class EntityEntityRelationshipGraph
extends RelationshipGraph<Entity, EntityEntityEdge> {
    private static final Logger log = LogManager.getLogger((String)EntityEntityRelationshipGraph.class.getName());

    public void addEdges(ResourceId docId, Set<DocumentEntityRelation> docEntityRelations) {
        HashSet<Entity> entities = new HashSet<Entity>();
        for (DocumentEntityRelation rel : docEntityRelations) {
            entities.add(rel.getEntity());
        }
        LinkedList<Entity> entitiesList = new LinkedList<Entity>();
        entitiesList.addAll(entities);
        if (entitiesList.size() > 1) {
            int i = 0;
            while (i < entitiesList.size() - 1) {
                int j = i + 1;
                while (j < entitiesList.size() - 1) {
                    this.addEdge((Entity)entitiesList.get(i), (Entity)entitiesList.get(j));
                    ++j;
                }
                ++i;
            }
        }
    }

    private void addEdge(Entity entityA, Entity entityB) {
        this.graph.addVertex((Object)entityA);
        this.graph.addVertex((Object)entityB);
        EntityEntityEdge newEdge = new EntityEntityEdge(entityA, entityB);
        boolean added = this.graph.addEdge((Object)entityA, (Object)entityB, (Object)newEdge);
        if (!added) {
            ((EntityEntityEdge)this.graph.getEdge((Object)entityA, (Object)entityB)).increaseWeight();
        }
    }

    @Override
    protected EdgeFactory<Entity, EntityEntityEdge> getEdgeFactory() {
        log.error("getEdgeFactory not implemented");
        throw new NotImplementedException("getEdgeFactory not implemented");
    }
}

