/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import it.jrc.osint.analysis.graph.SimpleTableGraph;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleTableGraphTest {
    private String[] v;
    private String[] e;

    @Before
    public void setup() {
        this.v = new String[]{"v1", "v2", "v3", "v4", "v5"};
        this.e = new String[]{"e1", "e2", "e3", "e4", "e5", "e6"};
    }

    @Test
    public void addVertexSuccess() {
        SimpleTableGraph graph = new SimpleTableGraph();
        Assert.assertTrue((boolean)graph.addVertex(this.v[0]));
        Assert.assertFalse((boolean)graph.addVertex(this.v[0]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[1]));
        Assert.assertTrue((boolean)graph.containsVertex(this.v[0]));
        Assert.assertFalse((boolean)graph.containsVertex(this.v[2]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddEdge_vertexNotExisting() {
        SimpleTableGraph graph = new SimpleTableGraph();
        graph.addEdge(this.v[0], this.v[1], this.e[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEdge_vertexNull_1() {
        SimpleTableGraph graph = new SimpleTableGraph();
        graph.addEdge(null, this.v[1], this.e[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testAddEdge_vertexNull_2() {
        SimpleTableGraph graph = new SimpleTableGraph();
        graph.addEdge(this.v[0], null, this.e[0]);
    }

    @Test
    public void testAddEdge() {
        SimpleTableGraph graph = new SimpleTableGraph();
        Assert.assertTrue((boolean)graph.addVertex(this.v[0]));
        Assert.assertFalse((boolean)graph.addVertex(this.v[0]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[1]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[1], this.e[0]));
        Assert.assertFalse((boolean)graph.addEdge(this.v[0], this.v[1], this.e[0]));
        Assert.assertFalse((boolean)graph.addEdge(this.v[1], this.v[0], this.e[0]));
        Assert.assertTrue((boolean)graph.containsEdge(this.e[0]));
        Assert.assertFalse((boolean)graph.containsEdge(this.e[1]));
        Assert.assertTrue((boolean)graph.containsEdge(this.v[0], this.v[1]));
        Assert.assertFalse((boolean)graph.containsEdge(this.v[1], this.v[2]));
    }

    @Test
    public void testDegreeOf() {
        SimpleTableGraph<String, String> graph = new SimpleTableGraph<String, String>();
        Assert.assertTrue((boolean)graph.addVertex(this.v[0]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[1]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[2]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[3]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[4]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[1], this.e[0]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[2], this.e[1]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[3], this.e[2]));
        Assert.assertTrue((3 == graph.degreeOf(this.v[0]) ? 1 : 0) != 0);
        Assert.assertTrue((1 == graph.degreeOf(this.v[1]) ? 1 : 0) != 0);
        Assert.assertTrue((graph.degreeOf(this.v[4]) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEdgeSet() {
        SimpleTableGraph<String, String> graph = new SimpleTableGraph<String, String>();
        Assert.assertTrue((boolean)graph.addVertex(this.v[0]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[1]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[2]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[3]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[4]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[1], this.e[0]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[2], this.e[1]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[3], this.e[2]));
        Assert.assertTrue((3 == graph.edgeSet().size() ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveEdge() {
        SimpleTableGraph<String, String> graph = new SimpleTableGraph<String, String>();
        Assert.assertTrue((boolean)graph.addVertex(this.v[0]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[1]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[2]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[3]));
        Assert.assertTrue((boolean)graph.addVertex(this.v[4]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[1], this.e[0]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[2], this.e[1]));
        Assert.assertTrue((boolean)graph.addEdge(this.v[0], this.v[3], this.e[2]));
        Assert.assertTrue((3 == graph.edgeSet().size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)graph.removeEdge(this.e[1]));
        Assert.assertTrue((2 == graph.edgeSet().size() ? 1 : 0) != 0);
    }
}

