/*
 * Decompiled with CFR 0.152.
 */
package test.internal;

import it.jrc.osint.analysis.parser.ParseException;
import it.jrc.osint.analysis.parser._ElementParserBase;
import it.jrc.rss.SimpleElement;
import org.junit.Assert;
import org.junit.Test;

public class TestElementParserBase
extends _ElementParserBase {
    @Test
    public void testGetMandatoryAttribute_existing() {
        SimpleElement se = this.getTestElement();
        String value = null;
        try {
            value = this.getMandatoryAttribute(se, "id");
        }
        catch (ParseException pe) {
            Assert.fail((String)"Failed to obtain mandatory element");
        }
        Assert.assertEquals((Object)value, (Object)"id");
    }

    @Test
    public void testGetMandatoryAttribute_notExisting() {
        SimpleElement se = this.getTestElement();
        String value1 = null;
        try {
            value1 = this.getMandatoryAttribute(se, "not-existing");
            Assert.fail((String)"Must throw ParseException if attribute is not found");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testIntArrayParsing_validInput() throws ParseException {
        SimpleElement se = this.getTestElement();
        String posStr = this.getMandatoryAttribute(se, "pos");
        int[] result = this.toIntArray(posStr);
        Assert.assertEquals((long)result.length, (long)2L);
        Assert.assertEquals((long)result[0], (long)10L);
        Assert.assertEquals((long)result[1], (long)20L);
    }

    @Test
    public void testIntArrayParsing_extraSeparator() throws ParseException {
        SimpleElement se = this.getTestElement();
        String posStr = this.getMandatoryAttribute(se, "pos_extra-separator");
        int[] result = this.toIntArray(posStr);
        Assert.assertEquals((long)result.length, (long)2L);
        Assert.assertEquals((long)result[0], (long)10L);
        Assert.assertEquals((long)result[1], (long)20L);
    }

    private SimpleElement getTestElement() {
        SimpleElement se = new SimpleElement("emm:entity");
        se.addAttribute("id", "id");
        se.addAttribute("pos", "10,20");
        se.addAttribute("pos_extra-separator", "10,20,");
        return se;
    }
}

