/*
 * Decompiled with CFR 0.152.
 */
package test.internal;

import it.jrc.osint.analysis.parser.ElementParsingResultImpl;
import it.jrc.osint.analysis.parser.EntityElementParser;
import it.jrc.osint.analysis.parser.ParseException;
import it.jrc.osint.util.io.FileUtil;
import it.jrc.rss.RSS;
import it.jrc.rss.RSSItem;
import it.jrc.rss.RSSParser;
import it.jrc.rss.SimpleElement;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEntityElementParser {
    private RSS rss;

    @Test
    public void testIsEntityElement() {
        EntityElementParser eep = new EntityElementParser();
        SimpleElement se1 = new SimpleElement("emm:entity");
        se1.addAttribute("type", "p");
        Assert.assertEquals((Object)eep.isEntityElement(se1), (Object)true);
        SimpleElement se2 = new SimpleElement("emm:entity");
        se2.addAttribute("type", "o");
        Assert.assertEquals((Object)eep.isEntityElement(se2), (Object)true);
        SimpleElement se3 = new SimpleElement("emm:georss");
        Assert.assertEquals((Object)eep.isEntityElement(se3), (Object)true);
        SimpleElement se4 = new SimpleElement("emm:semail");
        Assert.assertEquals((Object)eep.isEntityElement(se4), (Object)true);
        SimpleElement se5 = new SimpleElement("emm:sip");
        Assert.assertEquals((Object)eep.isEntityElement(se5), (Object)true);
        SimpleElement se6 = new SimpleElement("emm:surl");
        Assert.assertEquals((Object)eep.isEntityElement(se6), (Object)true);
        SimpleElement se7 = new SimpleElement("emm:sdate");
        Assert.assertEquals((Object)eep.isEntityElement(se7), (Object)true);
        SimpleElement se8 = new SimpleElement("emm:stel");
        Assert.assertEquals((Object)eep.isEntityElement(se8), (Object)true);
        SimpleElement se9 = new SimpleElement("emm:screditcard");
        Assert.assertEquals((Object)eep.isEntityElement(se9), (Object)true);
    }

    @Before
    public void loadRSS() throws Exception {
        String filePath = "W:\\work\\repository\\osint-v2\\it.jrc.osint.analysis\\test\\38883c91-f0ab-4652-ae32-89bf4b73fa53.osd";
        RSSParser rssParser = new RSSParser();
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(filePath);
            this.rss = rssParser.parse((Reader)new InputStreamReader((InputStream)fileIn, "utf-8"));
        }
        catch (Throwable throwable) {
            FileUtil.close(fileIn);
            throw throwable;
        }
        FileUtil.close((InputStream)fileIn);
    }

    @Test
    public void testParseSimpleElements() {
        RSSItem item = (RSSItem)this.rss.getItems().get(0);
        ArrayList elements = item.getElements();
        for (SimpleElement se : elements) {
            EntityElementParser parser = new EntityElementParser();
            ElementParsingResultImpl epr = new ElementParsingResultImpl();
            try {
                parser.parseElement(se, epr);
                System.out.println(epr.toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

