/*
 * Decompiled with CFR 0.152.
 */
package it.jrc.osint.index.ui.views;

import it.jrc.osint.ResourceId;
import it.jrc.osint.index.IndexPlugin;
import it.jrc.osint.index.IndexService;
import it.jrc.osint.index.IndexServiceEvent;
import it.jrc.osint.index.internal.IndexServiceEventImpl;
import it.jrc.osint.index.ui.views.DocForTreeViewer;
import it.jrc.osint.index.ui.views.IndexSearchUIView;
import it.jrc.osint.logging.LogManager;
import it.jrc.osint.logging.Logger;
import it.jrc.osint.util.event.SystemEvent;
import it.jrc.osint.util.event.TopicEventListener;
import it.jrc.osint.util.event.TopicEventListenerAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.document.Document;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class IndexSearchUIController {
    private static final Logger log = LogManager.getLogger((String)IndexSearchUIController.class.getName());
    private IndexSearchUIView view;
    private IndexService indexService;
    private TopicEventListener topicEventListener = new TopicEventListenerImpl();

    public IndexSearchUIController(IndexSearchUIView view) {
        this.view = view;
        this.indexService = IndexPlugin.getIndexService();
        IndexPlugin.getEventBroker().register(new String[]{"osint/index", "osint/index/startUpdateIndex", "osint/index/finishUpdateIndex"}, this.topicEventListener);
    }

    public DocForTreeViewer[] listDocToArray(List<Document> listdoc) {
        ArrayList<DocForTreeViewer> arraylistresult = new ArrayList<DocForTreeViewer>();
        HashSet<String> projects = new HashSet<String>();
        for (Document doc : listdoc) {
            String actualproject = doc.getField("project_id").stringValue();
            if (projects.contains(actualproject)) continue;
            ArrayList<DocForTreeViewer> projectarraylist = new ArrayList<DocForTreeViewer>();
            for (Document tempdoc : listdoc) {
                if (!tempdoc.getField("project_id").stringValue().equals(actualproject)) continue;
                String tempResourceId = tempdoc.getField("resource_id").stringValue();
                String title = tempdoc.getField("title").stringValue();
                String type = tempdoc.getField("type").stringValue();
                projectarraylist.add(new DocForTreeViewer(title, tempResourceId, type));
            }
            DocForTreeViewer[] projectarray = projectarraylist.toArray(new DocForTreeViewer[projectarraylist.size()]);
            String projecttit = String.valueOf(this.indexService.getProjectTitle(new ResourceId(actualproject))) + " (" + projectarraylist.size() + " documents)";
            DocForTreeViewer dataproject = new DocForTreeViewer(projecttit, actualproject, projectarray);
            arraylistresult.add(dataproject);
            projects.add(actualproject);
        }
        return arraylistresult.toArray(new DocForTreeViewer[arraylistresult.size()]);
    }

    public void performLocalSearch(String queryString) {
        if (queryString != null && queryString.length() > 0 && this.indexService.getNumDocsGlobalIndex() > 0) {
            this.view.cleanSearchResultLabel();
            this.view.showProgressMessage("Searching local documents - Please wait ...");
            log.info("Local index contains a total of " + this.indexService.getNumDocsGlobalIndex() + " documents");
            this.indexService.performSearch(queryString, this.indexService.getNumDocsGlobalIndex());
        } else {
            if (this.indexService.getNumDocsGlobalIndex() == 0) {
                this.view.showProgressMessage("There are no local documents indexed");
            } else {
                this.view.showProgressMessage("");
            }
            this.view.getSearchResultLabel().setText("");
        }
    }

    public void openDocument(ResourceId id, IWorkbenchPartSite partSite) {
        try {
            ICommandService cmdService = (ICommandService)partSite.getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)partSite.getService(IHandlerService.class);
            Command openDocView = cmdService.getCommand("osint.analysis.command.OpenDocumentViewer");
            IParameter urlParam = openDocView.getParameter("url");
            Parameterization parm = new Parameterization(urlParam, id.toString());
            ParameterizedCommand parmCommand = new ParameterizedCommand(openDocView, new Parameterization[]{parm});
            handlerService.executeCommand(parmCommand, null);
        }
        catch (Throwable t) {
            log.error("Failed to open document for id " + id, t);
        }
    }

    public void showSearchResults(List<Document> resultlist) {
        DocForTreeViewer[] dataset = new DocForTreeViewer[]{};
        if (resultlist != null && resultlist.size() > 0) {
            dataset = this.listDocToArray(resultlist);
        }
        this.view.setSearchResults(dataset);
    }

    public int getNumberDocumentsRetrieved(DocForTreeViewer[] dataset) {
        int size = 0;
        int i = 0;
        while (i < dataset.length) {
            DocForTreeViewer project = dataset[i];
            size += project.children.length;
            ++i;
        }
        return size;
    }

    public void performRefreshView(String type) {
        type.equals("osint/index/startUpdateIndex");
    }

    private class TopicEventListenerImpl
    extends TopicEventListenerAdapter {
        private TopicEventListenerImpl() {
        }

        public void handleEvent(SystemEvent event) {
            if (!(event instanceof IndexServiceEvent)) {
                return;
            }
            if ("osint/index".equals(event.getTopic())) {
                IndexServiceEventImpl isEvent = (IndexServiceEventImpl)event;
                IndexSearchUIController.this.showSearchResults(isEvent.getSearchResults());
            }
            "osint/index/startUpdateIndex".equals(event.getTopic());
            "osint/index/finishUpdateIndex".equals(event.getTopic());
        }
    }
}

